package com.bizvane.connectorservice.entity.icrm;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class VgAddCouponDefinitionVo {
    private String brandCode;
    private Boolean brandMainMaster;
    private Byte useChannel;
    private String applicableBrandCodes;
    private String couponDefinitionCode;
    private String couponName;
    private String info;
    private Byte preferentialType;
    /**
     * 折扣券：最大优惠金额
     */
    private BigDecimal maxPreferential;
    private BigDecimal money;
    private BigDecimal discount;
    private BigDecimal minConsume;
    private BigDecimal minDiscount;
    private String storeWhitelist;
    private String storeBlacklist;
    private String commodityWhitelist;
    private String commodityBlacklist;
    //是否允许叠加（true 允许, false 不允许）
    private Boolean isSuperposition;
    //商品数量最高限制
    private Integer goodsCondition;

    /**
     * 有效期类型
     */
    private Byte validType;

    /**
     * 有效期开始时间
     */
    private Date validDateStart;

    /**
     * 有效期结束时间
     */
    private Date validDateEnd;

    /**
     * 有效天数
     */
    private Integer validDay;

    /**
     * 单人领取数最大限制
     */
    private Integer perMaxNum;

    /**
     * 是否允许活动叠加
     */
    private Integer activitySuperpositionType;

    /**
     * 券等级
     */
    private Integer level;

}
