package com.bizvane.connectorservice.util;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author liuying
 * @date 2018/8/15
 * @description
 */

public class DateUtil {

    private final static String YYYY_MMDD = "yyyyMMdd";
    public final static String ymdhms = "yyyy-MM-dd HH:mm:ss";
    /**
     * 转换时间为yyyyMMdd格式
     * @param date
     * @return
     */
    public static String dateFormatDate(Date date){
        if(date == null){
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY_MMDD);
        String format = simpleDateFormat.format(date);
        return format;
    }
    public static String dateFormatDates(Date date){
        if(date == null){
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ymdhms);
        String format = simpleDateFormat.format(date);
        return format;
    }
    /**
     * 获取当前的时间,静态方法
     * @return
     */
    public static String getCurrentStateTime() {
        return new SimpleDateFormat(ymdhms).format(new Date());
    }

    /**
     * 校验时间格式是否是：yyyy-MM-dd HH:mm:ss
     * @param date
     * @return
     */
    public static boolean isValidDate(String date) {
        boolean convertSuccess=true;
        SimpleDateFormat format = new SimpleDateFormat(ymdhms);
        try {
            format.setLenient(false);
            format.parse(date);
        } catch (Exception e) {
            convertSuccess=false;
            date = getCurrentStateTime();
        }
        return convertSuccess;
    }

    /**
     * 将时间格式化成  yyyy-MM-dd HH:mm:ss
     * 默认为当前格式
     * @param date
     */
    public static String transformDateToStandard( String date ){
        SimpleDateFormat format = new SimpleDateFormat(ymdhms);
        try {
            format.parse(date);
            return date;
        } catch (Exception e) {
            return getCurrentStateTime();
        }
    }

}
