package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.yzw.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * @author xiao.shu
 * @date 2019/10/15
 * @description
 */

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/yzw")
public interface YzwConnectorServiceFeign {

    /**
     * 获取储值卡资料
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="getRechargeCards",method = RequestMethod.POST)
    ResponseData<List<RechargeCardInfoResponseVo>> getRechargeCards(RechargeCardInfoRequestVo requestVo);

    /**
     * 获取储值卡流水
     * @param requestVO
     * @return
     */
    @RequestMapping(value ="getRechargeRecords",method = RequestMethod.POST)
    ResponseData<List<RechargeRecordInfoResponseVo>> getRechargeRecordsInfo(RechargeRecordInfoRequestVo requestVO);

    /**
     * 增加推荐人信息
     * @param requestVO
     * @return
     * */
    @RequestMapping(value ="addRecommend",method = RequestMethod.POST)
    ResponseData addRecommend(AddRecommendRequestVo requestVO);


}
