package com.bizvane.connectorservice.entity.icrm;

import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
/**
 * @author admin
 */
@ToString
public class ConsumePayVO implements Serializable {


    @ApiModelProperty(
            value = "单据编号",
            name = "record_code",
            required = false,
            example = ""
    )
    private String record_code;

    @ApiModelProperty(
            value = "支付金额",
            name = "money",
            required = false,
            example = ""
    )
    private BigDecimal money;

    @ApiModelProperty(
            value = "使用积分",
            name = "integral_used",
            required = false,
            example = ""
    )
    private String integral_used;

    @ApiModelProperty(
            value = "支付方式代码",
            name = "pay_code",
            required = false,
            example = ""
    )
    /**
     * bank 银行汇款/转帐
     * balance 余额支付
     * alipay 支付宝
     * tenpay 财付通
     * chinabank 网银在线
     * cod 货到付款
     * cash 现金支付
     * immediately 即时到账
     * weixin 微信支付
     */
    private String pay_code;

    @ApiModelProperty(
            value = "支付方式名称",
            name = "pay_name",
            required = false,
            example = ""
    )
    private String pay_name;

    @ApiModelProperty(
            value = "支付使用的优惠券号",
            name = "coupon_code",
            required = false,
            example = ""
    )
    private String coupon_code;

    @ApiModelProperty(
            value = "0-表示减积分 1-表示加积分，默认0",
            name = "is_return",
            required = false,
            example = ""
    )
    private String is_return;

    public String getRecord_code() {
        return record_code;
    }

    public void setRecord_code(String record_code) {
        this.record_code = record_code;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getIntegral_used() {
        return integral_used;
    }

    public void setIntegral_used(String integral_used) {
        this.integral_used = integral_used;
    }

    public String getPay_code() {
        return pay_code;
    }

    public void setPay_code(String pay_code) {
        this.pay_code = pay_code;
    }

    public String getPay_name() {
        return pay_name;
    }

    public void setPay_name(String pay_name) {
        this.pay_name = pay_name;
    }

    public String getCoupon_code() {
        return coupon_code;
    }

    public void setCoupon_code(String coupon_code) {
        this.coupon_code = coupon_code;
    }

    public String getIs_return() {
        return is_return;
    }

    public void setIs_return(String is_return) {
        this.is_return = is_return;
    }
}
