package com.bizvane.connectorservice.interfaces.jh;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.VgAddCouponDefinitionVo;
import com.bizvane.connectorservice.entity.icrm.VgAddCouponVO;
import com.bizvane.connectorservice.entity.icrm.VgCancelCouponVo;
import com.bizvane.connectorservice.entity.icrm.VgUseCouponVo;
import com.bizvane.connectorservice.entity.req.*;
import org.apache.poi.ss.formula.functions.T;

/**
 * @program: connector
 * @description: Crm对接商城接口
 * @author: Liu Xinpeng
 * @create: 2021-03-02 14:53
 **/
public interface CrmJointService {


    /**
     * 券定义
     * @param vgAddCouponDefinitionVo
     * @return
     */
    Result<T> snyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo);

    /**
     * 发券
     * @param vgAddCouponVO
     * @return
     */
    Result<T> snyMemberCoupon(VgAddCouponVO vgAddCouponVO);


    /**
     * 优惠券作废
     * @param vgCancelCouponVo
     * @return
     */
    Result<T> snyCouponStatus(VgCancelCouponVo vgCancelCouponVo);


    /**
     * 优惠券核销
     * @param vgCancelCouponVo
     * @return
     */
    Result<T> snyCouponCancel(VgCancelCouponVo vgCancelCouponVo);


    /**
     * 优惠券转增
     * @param snyCouponTransferReq
     * @return
     */
    Result<T> snyCouponTransfer(SnyCouponTransferReq snyCouponTransferReq);

    /**
     * 会员权益
     * @param snyMemberRightsReq
     * @return
     */
    Result<T> snyMemberRights(SnyMemberRightsReq snyMemberRightsReq);



}