package com.bizvane.connectorservice.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @Author sampson
 * @Date 2021-02-08 12:31
 * @Describe 积分请求线下实体
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class OfflineIntegralRequestVo {
    /**
     * 俱乐部code
     */
    // @NotBlank(message = "品牌code不能为空")
    // @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    /**
     * 集团会员卡号
     */
    // @NotBlank(message = "集团会员卡号不允许为空")
    private String cardNo;
    /**
     * 变更流水号
     */
    // @NotBlank(message = "变更流水号不允许为空")
    private String serialNumber;
    /**
     * 调整的积分数量
     */
    // @NotNull(message = "调整的积分数量不允许为空")
    private Integer integral;
    /**
     * 调整时间,格式：yyyy-MM-dd HH:mm:ss
     */
    // @NotBlank(message = "积分获取时间不允许为空")
    // @Pattern(regexp = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s+([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$" , message = "积分获取时间不符合格式 : yyyy-MM-dd HH:mm:ss ")
    private String changeTime;
    /**
     * 变更单号
     */
    private String orderNo;
    /**
     * 积分来源
     * 积分来源:1.POS(门店) 2.官网 3.商城 4.微信 5.天猫 6.其他
     */
    // @NotBlank(message = "积分来源不允许为空")
    private String source;
    /**
     * 变更店铺code
     */
    private String storeCode;
    /**
     * 变更说明（例如：积分清零、签到送积分）
     */
    private String changeRemark ;

}
