package com.bizvane.connectorservice.interfaces.vg;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.Result;

/**
 * @author admin
 */
public interface VgCouponService {

    /**
     * 单张发券
     * @param requestVO
     * @return
     */
    Result<JSONObject> sendCoupon(JSONObject requestVO,String club);
    /**
     * 批量发券
     * @param requestVO
     * @return
     */
    Result<JSONObject> sendCouponBatch(JSONObject requestVO);

    /**
     * 券规则新增
     * @param requestVO
     * @return
     */
    Result<JSONObject> addCouponGrp(JSONObject requestVO,String tag);
    /**
     * 券转赠
     * @param requestVO
     * @return
     */
    Result<JSONObject> giveCoupon(JSONObject requestVO);
    /**
     * 券批量作废
     * @param requestVO
     * @return
     */
    Result<JSONObject> cancelCouponBatch(JSONObject requestVO,String tag);

    /**
     * 券核销
     * @param requestVO
     * @return
     */
    Result<JSONObject> useCoupon(JSONObject requestVO,String tag);

}
