package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import com.bizvane.connectorservice.entity.vo.MemberInfoQueryRequestVO;
import com.bizvane.connectorservice.entity.vo.MemberInfoQueryResponseVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author liuying
 * @date 2018/8/15
 * @description
 */

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/rest")
public interface ConnectorServiceFeign {

    /**
     * 调整积分
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "adjustintegral", method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> adjustintegral(@RequestBody IntegralAdjustRequestVO requestVO);

    /**
     * 登陆,绑卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "login", method = RequestMethod.POST)
    Result<MemberLoginResponseVO> login(@RequestBody MemberLoginRequestVO requestVO);

    /**
     * 线下开卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "opencard", method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> opencard(@RequestBody MemberOpenCardRequestVO requestVO);

    /**
     * 会员升降级
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifymembergrade", method = RequestMethod.POST)
    Result modifymembergrade(@RequestBody MemberModifyGradeRequestVO requestVO);

    /**
     * 修改个人资料
     * @param requestVO
     * @return
     */
    @RequestMapping(value="updateuserinfo",method = RequestMethod.POST)
    Result updateuserinfo(@RequestBody MemberInfoUpdateRequestVO requestVO);

    /**
     * 登陆,绑卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "loginandopencard", method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> loginandopencard(@RequestBody MemberOpenCardRequestVO requestVO);


    /**
     * 会员资料查询
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "querymemberinfo", method = RequestMethod.POST)
    Result<MemberInfoQueryResponseVO> querymemberinfo(@RequestBody MemberInfoQueryRequestVO requestVO);


    /**
     * ---------------------------------------------
     *
     * 线下会员积分流水查询接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value="getintegrallist",method = RequestMethod.POST)
    Result<IntegralListResponseVO> getIntegralList(@RequestBody IntegralListRequestVO requestVO);

    /**
     *储值卡金额扣减
     * @param requestVO
     * @return
     */
    @RequestMapping(value="deductionbalance",method = RequestMethod.POST)
    Result deductionbalance(@RequestBody DeductionbalanceRequestVO requestVO);


    /**
     * 修改手机号
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifyphone", method = RequestMethod.POST)
    Result modifyphone(@RequestBody MemberPhoneUpdateRequestVO requestVO);

    /**
     * 金利来
     * 会员打标签
     * @param requestVO
     * @return
     */
    @PostMapping(value = "mbrlabelrecord", produces = MediaType.APPLICATION_JSON_VALUE)
    Result<String> mbrLabelRecord(@RequestBody MbrLabelRecordRequestVO requestVO);

    /**
     *阿里绑定调线下
     * @param requestVO
     * @return
     */
    @RequestMapping(value="tmallbindtoerp",method = RequestMethod.POST)
    Result tmallBindToErp(@RequestBody MemberBindToErpRequestVO requestVO);


}
