package com.bizvane.connectorservice.interfaces.jh;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.req.*;
import org.apache.poi.ss.formula.functions.T;

/**
 * @program: connector
 * @description: Crm对接商城接口
 * @author: Liu Xinpeng
 * @create: 2021-03-02 14:53
 **/
public interface CrmJointService {


    /**
     * 同步优惠券活动信息
     * @param snyCouponInfoReq
     * @return
     */
    Result<T> snyCouponInfo(SnyCouponInfoReq snyCouponInfoReq);

    /**
     * 同步优惠券活动信息
     * @param snyMemberCouponReq
     * @return
     */
    Result<T> snyMemberCoupon(SnyMemberCouponReq snyMemberCouponReq);


    /**
     * 优惠券(全渠道)状态变更
     * @param snyCouponStatusReq
     * @return
     */
    Result<T> snyCouponStatus(SnyCouponStatusReq snyCouponStatusReq);


    /**
     * 优惠券转增
     * @param snyCouponTransferReq
     * @return
     */
    Result<T> snyCouponTransfer(SnyCouponTransferReq snyCouponTransferReq);

    /**
     * 会员权益
     * @param snyMemberRightsReq
     * @return
     */
    Result<T> snyMemberRights(SnyMemberRightsReq snyMemberRightsReq);



}