package com.bizvane.connectorservice.entity.vo;

import com.bizvane.connectorservice.util.valid.EnumStringValue;
import com.bizvane.connectorservice.util.valid.StringBrandCode;
import com.bizvane.connectorservice.util.valid.StringGender;
import com.bizvane.connectorservice.util.valid.StringValid;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * @Author sampson
 * @Date 2021-02-06 21:10
 * @Describe
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class OfflineMemberRequestVo {
    /**
     * 俱乐部code
     */
    // @NotBlank(message = "品牌code不能为空")
    // @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    /**
     * 集团会员卡号
     */
    // @NotBlank(message = "集团会员卡号不允许为空")
    private String cardNo;
    /**
     * 俱乐部卡等级编码
     */
    // @NotBlank(message = "俱乐部卡等级编码不允许为空")
    private String levelCode;
    /**
     * 开卡门店编码
     */
    private String storeCode;
    /**
     * 开卡导购编码
     */
    private String guideCode;
    /**
     * 服务门店编码
     */
    private String serviceStoreCode;
    /**
     * 服务导购编码
     */
    private String serviceGuideCode;
    /**
     * 开卡时间
     */
    // @NotBlank(message = "开卡时间不允许为空")
    // @Pattern(regexp = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s+([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$" , message = "开卡时间不符合格式 : yyyy-MM-dd HH:mm:ss ")
    private String openCardTime;
    /**
     * 有效期
     */
    private Integer validDate;
    /**
     * 手机号
     */
    // @NotBlank(message = "手机号不允许为空")
    // @Pattern(regexp="^[1][3,4,5,7,8,9][0-9]{9}$",message = "手机号格式不正确")
    private String mobile;
    /**
     * 姓名
     */
    private String name;
    /**
     * 性别 M=男 W=女 N=未知、保密
     */
    // @EnumStringValue(StringGender.class)
    private String sex;
    /**
     * 生日，8位数字（示例：19701011）
     */
    private Integer birthday;
    /**
     * 是否可用，Y=是、N=否
     */
    // @NotBlank(message = "是否可用不能为空")
    // @EnumStringValue(StringValid.class)
    private String valid;



}
