package com.bizvane.connectorservice.entity.po;

import com.bizvane.connectorservice.entity.base.BaseModel;

import java.io.Serializable;
import java.util.Date;

/**
 * t_sys_staff 企业员工表
 * @author Bizvane
 */
public class StaffPo extends BaseModel implements Serializable {
    /**
     * pkid
     */
    private Long sysStaffId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 员工编号
     */
    private String staffCode;

    /**
     * 员工姓名
     */
    private String staffName;

    /**
     * 国家区号
     */
    private String countryCode;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮件
     */
    private String email;

    /**
     * 性别 0：女   1： 男
     */
    private String sex;

    /**
     * 生日
     */
    private Date birthday;

    /**
     * 头像
     */
    private String imgs;

    /**
     * 职务
     */
    private String position;

    /**
     * 登陆账号
     */
    private String loginAccount;

    /**
     * 状态：0=禁用；1=启用
     */
    private Boolean status;

    /**
     * 启用时间
     */
    private Date onDate;

    /**
     * 停用时间
     */
    private Date offDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long modifiedUserId;

    /**
     * 修改人
     */
    private String modifiedUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;

    /**
     * 数据有效性：1=有效；0=无效
     */
    private Boolean valid;

    /**
     * 线下员工id
     */
    private String staffId;
    /**
     * 店铺线下编号
     */
    private String sysStoreOfflineCode;

    /**
     * t_sys_staff
     */
    private static final long serialVersionUID = 1L;

    /**
     * pkid
     * @return sys_staff_id pkid
     */
    public Long getSysStaffId() {
        return sysStaffId;
    }

    /**
     * pkid
     * @param sysStaffId pkid
     */
    public void setSysStaffId(Long sysStaffId) {
        this.sysStaffId = sysStaffId;
    }

    /**
     * 企业id
     * @return sys_company_id 企业id
     */
    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    /**
     * 企业id
     * @param sysCompanyId 企业id
     */
    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    /**
     * 员工编号
     * @return staff_code 员工编号
     */
    public String getStaffCode() {
        return staffCode;
    }

    /**
     * 员工编号
     * @param staffCode 员工编号
     */
    public void setStaffCode(String staffCode) {
        this.staffCode = staffCode == null ? null : staffCode.trim();
    }

    /**
     * 员工姓名
     * @return staff_name 员工姓名
     */
    public String getStaffName() {
        return staffName;
    }

    /**
     * 员工姓名
     * @param staffName 员工姓名
     */
    public void setStaffName(String staffName) {
        this.staffName = staffName == null ? null : staffName.trim();
    }

    /**
     * 国家区号
     * @return country_code 国家区号
     */
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * 国家区号
     * @param countryCode 国家区号
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode == null ? null : countryCode.trim();
    }

    /**
     * 手机号
     * @return phone 手机号
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 手机号
     * @param phone 手机号
     */
    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    /**
     * 邮件
     * @return email 邮件
     */
    public String getEmail() {
        return email;
    }

    /**
     * 邮件
     * @param email 邮件
     */
    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    /**
     * 性别 0：女   1： 男
     * @return sex 性别 0：女   1： 男
     */
    public String getSex() {
        return sex;
    }

    /**
     * 性别 0：女   1： 男
     * @param sex 性别 0：女   1： 男
     */
    public void setSex(String sex) {
        this.sex = sex == null ? null : sex.trim();
    }

    /**
     * 生日
     * @return birthday 生日
     */
    public Date getBirthday() {
        return birthday;
    }

    /**
     * 生日
     * @param birthday 生日
     */
    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    /**
     * 头像
     * @return imgs 头像
     */
    public String getImgs() {
        return imgs;
    }

    /**
     * 头像
     * @param imgs 头像
     */
    public void setImgs(String imgs) {
        this.imgs = imgs == null ? null : imgs.trim();
    }

    /**
     * 职务
     * @return position 职务
     */
    public String getPosition() {
        return position;
    }

    /**
     * 职务
     * @param position 职务
     */
    public void setPosition(String position) {
        this.position = position == null ? null : position.trim();
    }

    /**
     * 登陆账号
     * @return login_account 登陆账号
     */
    public String getLoginAccount() {
        return loginAccount;
    }

    /**
     * 登陆账号
     * @param loginAccount 登陆账号
     */
    public void setLoginAccount(String loginAccount) {
        this.loginAccount = loginAccount == null ? null : loginAccount.trim();
    }

    /**
     * 状态：0=禁用；1=启用
     * @return status 状态：0=禁用；1=启用
     */
    public Boolean getStatus() {
        return status;
    }

    /**
     * 状态：0=禁用；1=启用
     * @param status 状态：0=禁用；1=启用
     */
    public void setStatus(Boolean status) {
        this.status = status;
    }

    /**
     * 启用时间
     * @return on_date 启用时间
     */
    public Date getOnDate() {
        return onDate;
    }

    /**
     * 启用时间
     * @param onDate 启用时间
     */
    public void setOnDate(Date onDate) {
        this.onDate = onDate;
    }

    /**
     * 停用时间
     * @return off_date 停用时间
     */
    public Date getOffDate() {
        return offDate;
    }

    /**
     * 停用时间
     * @param offDate 停用时间
     */
    public void setOffDate(Date offDate) {
        this.offDate = offDate;
    }

    /**
     * 备注
     * @return remark 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 创建人id
     * @return create_user_id 创建人id
     */
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * 创建人id
     * @param createUserId 创建人id
     */
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 创建人
     * @return create_user_name 创建人
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人
     * @param createUserName 创建人
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    /**
     * 创建日期
     * @return create_date 创建日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 创建日期
     * @param createDate 创建日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 修改人id
     * @return modified_user_id 修改人id
     */
    public Long getModifiedUserId() {
        return modifiedUserId;
    }

    /**
     * 修改人id
     * @param modifiedUserId 修改人id
     */
    public void setModifiedUserId(Long modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    /**
     * 修改人
     * @return modified_user_name 修改人
     */
    public String getModifiedUserName() {
        return modifiedUserName;
    }

    /**
     * 修改人
     * @param modifiedUserName 修改人
     */
    public void setModifiedUserName(String modifiedUserName) {
        this.modifiedUserName = modifiedUserName == null ? null : modifiedUserName.trim();
    }

    /**
     * 修改时间
     * @return modified_date 修改时间
     */
    public Date getModifiedDate() {
        return modifiedDate;
    }

    /**
     * 修改时间
     * @param modifiedDate 修改时间
     */
    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    /**
     * 数据有效性：1=有效；0=无效
     * @return valid 数据有效性：1=有效；0=无效
     */
    public Boolean getValid() {
        return valid;
    }

    /**
     * 数据有效性：1=有效；0=无效
     * @param valid 数据有效性：1=有效；0=无效
     */
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    /**
     * 线下员工id
     * @return staff_id 线下员工id
     */
    public String getStaffId() {
        return staffId;
    }

    /**
     * 线下员工id
     * @param staffId 线下员工id
     */
    public void setStaffId(String staffId) {
        this.staffId = staffId == null ? null : staffId.trim();
    }

    public String getSysStoreOfflineCode() {
        return sysStoreOfflineCode;
    }

    public void setSysStoreOfflineCode(String sysStoreOfflineCode) {
        this.sysStoreOfflineCode = sysStoreOfflineCode;
    }

    @Override
    public String toString() {
        return "StaffPo{" +
                "sysStaffId=" + sysStaffId +
                ", sysCompanyId=" + sysCompanyId +
                ", staffCode='" + staffCode + '\'' +
                ", staffName='" + staffName + '\'' +
                ", countryCode='" + countryCode + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", sex='" + sex + '\'' +
                ", birthday=" + birthday +
                ", imgs='" + imgs + '\'' +
                ", position='" + position + '\'' +
                ", loginAccount='" + loginAccount + '\'' +
                ", status=" + status +
                ", onDate=" + onDate +
                ", offDate=" + offDate +
                ", remark='" + remark + '\'' +
                ", createUserId=" + createUserId +
                ", createUserName='" + createUserName + '\'' +
                ", createDate=" + createDate +
                ", modifiedUserId=" + modifiedUserId +
                ", modifiedUserName='" + modifiedUserName + '\'' +
                ", modifiedDate=" + modifiedDate +
                ", valid=" + valid +
                ", staffId='" + staffId + '\'' +
                ", sysStoreOfflineCode='" + sysStoreOfflineCode + '\'' +
                '}';
    }
}