package com.bizvane.connectorservice.entity.icrm;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

public class AddVipRequestVO extends IcrmBaseModel {

    @ApiModelProperty(
            value = "VIP卡号",
            name = "vip_code",
            required = true,
            example = ""
    )
    private String vip_code;

    @ApiModelProperty(
            value = "来源平台（6代表pos,商帆待定）",
            name = "source",
            required = true,
            example = ""
    )
    private String source="999";

    @ApiModelProperty(
            value = "手机号",
            name = "tel",
            required = true,
            example = ""
    )
    private String tel;

    @ApiModelProperty(
            value = "性别（1：男 2：女）",
            name = "customer_sex",
            required = false,
            example = ""
    )
    private String customer_sex;

    @ApiModelProperty(
            value = "顾客姓名",
            name = "customer_name",
            required = false,
            example = ""
    )
    private String customer_name;

    @ApiModelProperty(
            value = "生日",
            name = "birthday",
            required = false,
            example = ""
    )

    private String birthday;

    @ApiModelProperty(
            value = "会员系列代码必填",
            name = "series_code",
            required = true,
            example = ""
    )
    private String series_code;

    @ApiModelProperty(
            value = "会员等级代码",
            name = "level_code",
            required = false,
            example = ""
    )
    private String level_code;

    @ApiModelProperty(
            value = "会员等级更新时间",
            name = "update_level_time",
            required = false,
            example = ""
    )
    private String update_level_time;
    @ApiModelProperty(
            value = "备注",
            name = "remark",
            required = false,
            example = ""
    )
    private String remark;

    @ApiModelProperty(
            value = "微信号(openid)weixin_id和app_id必须一起传",
            name = "weixin_id",
            required = false,
            example = ""
    )
    private String weixin_id;

    @ApiModelProperty(
            value = "店铺code",
            name = "shop_code",
            required = false,
            example = ""
    )
    private String shop_code;

    @ApiModelProperty(
            value = "渠道代码",
            name = "org_code",
            required = false,
            example = ""
    )
    private String org_code;

    @ApiModelProperty(
            value = "邮箱",
            name = "email",
            required = false,
            example = ""
    )
    private String email;

    @ApiModelProperty(
            value = "国家id",
            name = "country",
            required = false,
            example = ""
    )
    private String country;

    @ApiModelProperty(
            value = "省份id",
            name = "province",
            required = false,
            example = ""
    )
    private String province;

    @ApiModelProperty(
            value = "城市id",
            name = "city",
            required = false,
            example = ""
    )
    private String city;

    @ApiModelProperty(
            value = "地区id",
            name = "district",
            required = false,
            example = ""
    )
    private String district;

    @ApiModelProperty(
            value = "地址",
            name = "address",
            required = false,
            example = ""
    )
    private String address;


    @ApiModelProperty(
            value = "推荐人代码",
            name = "recommand_person",
            required = false,
            example = ""
    )
    private String recommand_person;

    @ApiModelProperty(
            value = "添加时间",
            name = "is_add_time",
            required = false,
            example = ""
    )
    private String is_add_time;

    /**
     * 不必传
     */
    private VipDutyVO vip_duty;

    /**
     * 附加属性
     */
    private List property;

    @ApiModelProperty(
            value = "亲属关系",
            name = "family_relation",
            required = false,
            example = ""
    )
    private List<FamilyRelationVO>  family_relation;


    public String getVip_code() {
        return vip_code;
    }

    public void setVip_code(String vip_code) {
        this.vip_code = vip_code;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getCustomer_sex() {
        return customer_sex;
    }

    public void setCustomer_sex(String customer_sex) {
        this.customer_sex = customer_sex;
    }

    public String getCustomer_name() {
        return customer_name;
    }

    public void setCustomer_name(String customer_name) {
        this.customer_name = customer_name;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getSeries_code() {
        return series_code;
    }

    public void setSeries_code(String series_code) {
        this.series_code = series_code;
    }

    public String getLevel_code() {
        return level_code;
    }

    public void setLevel_code(String level_code) {
        this.level_code = level_code;
    }

    public String getUpdate_level_time() {
        return update_level_time;
    }

    public void setUpdate_level_time(String update_level_time) {
        this.update_level_time = update_level_time;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getWeixin_id() {
        return weixin_id;
    }

    public void setWeixin_id(String weixin_id) {
        this.weixin_id = weixin_id;
    }

    public String getShop_code() {
        return shop_code;
    }

    public void setShop_code(String shop_code) {
        this.shop_code = shop_code;
    }

    public String getOrg_code() {
        return org_code;
    }

    public void setOrg_code(String org_code) {
        this.org_code = org_code;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRecommand_person() {
        return recommand_person;
    }

    public void setRecommand_person(String recommand_person) {
        this.recommand_person = recommand_person;
    }

    public String getIs_add_time() {
        return is_add_time;
    }

    public void setIs_add_time(String is_add_time) {
        this.is_add_time = is_add_time;
    }

    public List getProperty() {
        return property;
    }

    public void setProperty(List property) {
        this.property = property;
    }

    public List<FamilyRelationVO> getFamily_relation() {
        return family_relation;
    }

    public void setFamily_relation(List<FamilyRelationVO> family_relation) {
        this.family_relation = family_relation;
    }

    public VipDutyVO getVip_duty() {
        return vip_duty;
    }

    public void setVip_duty(VipDutyVO vip_duty) {
        this.vip_duty = vip_duty;
    }
}
