package com.bizvane.connectorservice.interfaces.base;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.CouponBatchBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBatchRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBindRequestVO;

/**
 * @Author: liuying@bizvane.cn
 * @Date: 2019/3/12 9:55
 * @Version 1.0
 */
public interface CouponBindService {

    /**
     * 批量绑定线下券
     * @param requestVO
     * @return
     */
    default Result batchBindCoupon(CouponBatchBindRequestVO requestVO){
        return Result.returnStr(0,"default批量绑定线下优惠券成功");
    };

    /**
     * 批量绑定线下券回调
     * @param requestVo
     */

    void callbackBindCoupon(CouponBatchBindRequestVO requestVo)  throws Exception;


    /**
     * 绑定线下券单张
     * @param requestVO
     * @return
     */
    default Result singleBindCoupon(CouponBindRequestVO requestVO){
        return Result.returnStr(0,"default单张绑定线下优惠券成功");
    };

    /**
     * 绑定线下券单张回调
     * @param requestVo
     */

    void callbackSingleBindCoupon(CouponBindRequestVO requestVo)  throws Exception;
}
