package com.bizvane.connectorservice.entity.po;

import com.bizvane.connectorservice.entity.base.BaseModel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_sys_store 门店表
 * @author Bizvane
 */
public class StorePo extends BaseModel implements Serializable {
    /**
     * pkid
     */
    private Long sysStoreId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 店铺附属品牌 多个以逗号隔开
     */
    private String slaveSysBrandId;

    /**
     * 店铺线上编号
     */
    private String sysStoreOnlineCode;

    /**
     * 店铺线下编号
     */
    private String sysStoreOfflineCode;

    /**
     * 店铺线下id
     */
    private String storeId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 店铺电话
     */
    private String storePhone;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 区名称
     */
    private String areaName;

    /**
     * 详细地址
     */
    private String detailedAddress;

    /**
     * 线下区域
     */
    private String bizArea;

    /**
     * 经度
     */
    private String lng;

    /**
     * 纬度
     */
    private String lat;

    /**
     * 
     */
    private String storeImgs;

    /**
     * 店铺二维码url
     */
    private String storeOrcode;

    /**
     * 店铺二维码跳转地址
     */
    private String storeOrcodeRouteUrl;

    /**
     * 所属经销商公司名
     */
    private String distributorName;

    /**
     * 店铺类型；10=直营；20=非直营; 40=联营; 50=加盟店
     */
    private Integer storeType;

    /**
     * 店铺类型对应字典code
     */
    private String dictionaryCode;

    /**
     * 负责人
     */
    private String shopOwner;

    /**
     * 状态：0=禁用；1=启用
     */
    private Boolean status;

    /**
     * 启用时间
     */
    private Date onDate;

    /**
     * 停用时间
     */
    private Date offDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long modifiedUserId;

    /**
     * 修改人
     */
    private String modifiedUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;

    /**
     * 数据有效性：1=有效；0=无效
     */
    private Boolean valid;

    /**
     * 导购助手状态 1=启用；0=禁用
     */
    private Boolean staffState;

    /**
     * 智慧门店code
     */
    private String smartStoreCode;

    /**
     * 智慧门店名称
     */
    private String smartStoreName;

    /**
     * 附近门店是否显示 0:不显示 1:显示
     */
    private Boolean isDisplay;

    /**
     * 门店营业时间
     */
    private String storeBusinessTime;

    /**
     * 店铺线上线下标识10:线下 20:线上
     */
    private Integer modelType;

    /**
     * 营业状态 10：开店申请20：已开业 30：立项终止40：已撤除
     */
    private Integer businessStatus;

    /**
     * 店铺面积
     */
    private BigDecimal storeSize;

    /**
     * t_sys_store
     */
    private static final long serialVersionUID = 1L;

    /**
     * pkid
     * @return sys_store_id pkid
     */
    public Long getSysStoreId() {
        return sysStoreId;
    }

    /**
     * pkid
     * @param sysStoreId pkid
     */
    public void setSysStoreId(Long sysStoreId) {
        this.sysStoreId = sysStoreId;
    }

    /**
     * 企业id
     * @return sys_company_id 企业id
     */
    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    /**
     * 企业id
     * @param sysCompanyId 企业id
     */
    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    /**
     * 品牌id
     * @return sys_brand_id 品牌id
     */
    public Long getSysBrandId() {
        return sysBrandId;
    }

    /**
     * 品牌id
     * @param sysBrandId 品牌id
     */
    public void setSysBrandId(Long sysBrandId) {
        this.sysBrandId = sysBrandId;
    }

    /**
     * 店铺附属品牌 多个以逗号隔开
     * @return slave_sys_brand_id 店铺附属品牌 多个以逗号隔开
     */
    public String getSlaveSysBrandId() {
        return slaveSysBrandId;
    }

    /**
     * 店铺附属品牌 多个以逗号隔开
     * @param slaveSysBrandId 店铺附属品牌 多个以逗号隔开
     */
    public void setSlaveSysBrandId(String slaveSysBrandId) {
        this.slaveSysBrandId = slaveSysBrandId == null ? null : slaveSysBrandId.trim();
    }

    /**
     * 店铺线上编号
     * @return sys_store_online_code 店铺线上编号
     */
    public String getSysStoreOnlineCode() {
        return sysStoreOnlineCode;
    }

    /**
     * 店铺线上编号
     * @param sysStoreOnlineCode 店铺线上编号
     */
    public void setSysStoreOnlineCode(String sysStoreOnlineCode) {
        this.sysStoreOnlineCode = sysStoreOnlineCode == null ? null : sysStoreOnlineCode.trim();
    }

    /**
     * 店铺线下编号
     * @return sys_store_offline_code 店铺线下编号
     */
    public String getSysStoreOfflineCode() {
        return sysStoreOfflineCode;
    }

    /**
     * 店铺线下编号
     * @param sysStoreOfflineCode 店铺线下编号
     */
    public void setSysStoreOfflineCode(String sysStoreOfflineCode) {
        this.sysStoreOfflineCode = sysStoreOfflineCode == null ? null : sysStoreOfflineCode.trim();
    }

    /**
     * 店铺线下id
     * @return store_id 店铺线下id
     */
    public String getStoreId() {
        return storeId;
    }

    /**
     * 店铺线下id
     * @param storeId 店铺线下id
     */
    public void setStoreId(String storeId) {
        this.storeId = storeId == null ? null : storeId.trim();
    }

    /**
     * 门店名称
     * @return store_name 门店名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 门店名称
     * @param storeName 门店名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName == null ? null : storeName.trim();
    }

    /**
     * 店铺电话
     * @return store_phone 店铺电话
     */
    public String getStorePhone() {
        return storePhone;
    }

    /**
     * 店铺电话
     * @param storePhone 店铺电话
     */
    public void setStorePhone(String storePhone) {
        this.storePhone = storePhone == null ? null : storePhone.trim();
    }

    /**
     * 省名称
     * @return province_name 省名称
     */
    public String getProvinceName() {
        return provinceName;
    }

    /**
     * 省名称
     * @param provinceName 省名称
     */
    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName == null ? null : provinceName.trim();
    }

    /**
     * 市名称
     * @return city_name 市名称
     */
    public String getCityName() {
        return cityName;
    }

    /**
     * 市名称
     * @param cityName 市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName == null ? null : cityName.trim();
    }

    /**
     * 区名称
     * @return area_name 区名称
     */
    public String getAreaName() {
        return areaName;
    }

    /**
     * 区名称
     * @param areaName 区名称
     */
    public void setAreaName(String areaName) {
        this.areaName = areaName == null ? null : areaName.trim();
    }

    /**
     * 详细地址
     * @return detailed_address 详细地址
     */
    public String getDetailedAddress() {
        return detailedAddress;
    }

    /**
     * 详细地址
     * @param detailedAddress 详细地址
     */
    public void setDetailedAddress(String detailedAddress) {
        this.detailedAddress = detailedAddress == null ? null : detailedAddress.trim();
    }

    /**
     * 线下区域
     * @return biz_area 线下区域
     */
    public String getBizArea() {
        return bizArea;
    }

    /**
     * 线下区域
     * @param bizArea 线下区域
     */
    public void setBizArea(String bizArea) {
        this.bizArea = bizArea == null ? null : bizArea.trim();
    }

    /**
     * 经度
     * @return lng 经度
     */
    public String getLng() {
        return lng;
    }

    /**
     * 经度
     * @param lng 经度
     */
    public void setLng(String lng) {
        this.lng = lng == null ? null : lng.trim();
    }

    /**
     * 纬度
     * @return lat 纬度
     */
    public String getLat() {
        return lat;
    }

    /**
     * 纬度
     * @param lat 纬度
     */
    public void setLat(String lat) {
        this.lat = lat == null ? null : lat.trim();
    }

    /**
     * 
     * @return store_imgs 
     */
    public String getStoreImgs() {
        return storeImgs;
    }

    /**
     * 
     * @param storeImgs 
     */
    public void setStoreImgs(String storeImgs) {
        this.storeImgs = storeImgs == null ? null : storeImgs.trim();
    }

    /**
     * 店铺二维码url
     * @return store_orcode 店铺二维码url
     */
    public String getStoreOrcode() {
        return storeOrcode;
    }

    /**
     * 店铺二维码url
     * @param storeOrcode 店铺二维码url
     */
    public void setStoreOrcode(String storeOrcode) {
        this.storeOrcode = storeOrcode == null ? null : storeOrcode.trim();
    }

    /**
     * 店铺二维码跳转地址
     * @return store_orcode_route_url 店铺二维码跳转地址
     */
    public String getStoreOrcodeRouteUrl() {
        return storeOrcodeRouteUrl;
    }

    /**
     * 店铺二维码跳转地址
     * @param storeOrcodeRouteUrl 店铺二维码跳转地址
     */
    public void setStoreOrcodeRouteUrl(String storeOrcodeRouteUrl) {
        this.storeOrcodeRouteUrl = storeOrcodeRouteUrl == null ? null : storeOrcodeRouteUrl.trim();
    }

    /**
     * 所属经销商公司名
     * @return distributor_name 所属经销商公司名
     */
    public String getDistributorName() {
        return distributorName;
    }

    /**
     * 所属经销商公司名
     * @param distributorName 所属经销商公司名
     */
    public void setDistributorName(String distributorName) {
        this.distributorName = distributorName == null ? null : distributorName.trim();
    }

    /**
     * 店铺类型；10=直营；20=非直营; 40=联营; 50=加盟店
     * @return store_type 店铺类型；10=直营；20=非直营; 40=联营; 50=加盟店
     */
    public Integer getStoreType() {
        return storeType;
    }

    /**
     * 店铺类型；10=直营；20=非直营; 40=联营; 50=加盟店
     * @param storeType 店铺类型；10=直营；20=非直营; 40=联营; 50=加盟店
     */
    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    /**
     * 店铺类型对应字典code
     * @return dictionary_code 店铺类型对应字典code
     */
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    /**
     * 店铺类型对应字典code
     * @param dictionaryCode 店铺类型对应字典code
     */
    public void setDictionaryCode(String dictionaryCode) {
        this.dictionaryCode = dictionaryCode == null ? null : dictionaryCode.trim();
    }

    /**
     * 负责人
     * @return shop_owner 负责人
     */
    public String getShopOwner() {
        return shopOwner;
    }

    /**
     * 负责人
     * @param shopOwner 负责人
     */
    public void setShopOwner(String shopOwner) {
        this.shopOwner = shopOwner == null ? null : shopOwner.trim();
    }

    /**
     * 状态：0=禁用；1=启用
     * @return status 状态：0=禁用；1=启用
     */
    public Boolean getStatus() {
        return status;
    }

    /**
     * 状态：0=禁用；1=启用
     * @param status 状态：0=禁用；1=启用
     */
    public void setStatus(Boolean status) {
        this.status = status;
    }

    /**
     * 启用时间
     * @return on_date 启用时间
     */
    public Date getOnDate() {
        return onDate;
    }

    /**
     * 启用时间
     * @param onDate 启用时间
     */
    public void setOnDate(Date onDate) {
        this.onDate = onDate;
    }

    /**
     * 停用时间
     * @return off_date 停用时间
     */
    public Date getOffDate() {
        return offDate;
    }

    /**
     * 停用时间
     * @param offDate 停用时间
     */
    public void setOffDate(Date offDate) {
        this.offDate = offDate;
    }

    /**
     * 备注
     * @return remark 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 创建人id
     * @return create_user_id 创建人id
     */
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * 创建人id
     * @param createUserId 创建人id
     */
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 创建人
     * @return create_user_name 创建人
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人
     * @param createUserName 创建人
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    /**
     * 创建日期
     * @return create_date 创建日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 创建日期
     * @param createDate 创建日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 修改人id
     * @return modified_user_id 修改人id
     */
    public Long getModifiedUserId() {
        return modifiedUserId;
    }

    /**
     * 修改人id
     * @param modifiedUserId 修改人id
     */
    public void setModifiedUserId(Long modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    /**
     * 修改人
     * @return modified_user_name 修改人
     */
    public String getModifiedUserName() {
        return modifiedUserName;
    }

    /**
     * 修改人
     * @param modifiedUserName 修改人
     */
    public void setModifiedUserName(String modifiedUserName) {
        this.modifiedUserName = modifiedUserName == null ? null : modifiedUserName.trim();
    }

    /**
     * 修改时间
     * @return modified_date 修改时间
     */
    public Date getModifiedDate() {
        return modifiedDate;
    }

    /**
     * 修改时间
     * @param modifiedDate 修改时间
     */
    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    /**
     * 数据有效性：1=有效；0=无效
     * @return valid 数据有效性：1=有效；0=无效
     */
    public Boolean getValid() {
        return valid;
    }

    /**
     * 数据有效性：1=有效；0=无效
     * @param valid 数据有效性：1=有效；0=无效
     */
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    /**
     * 导购助手状态 1=启用；0=禁用
     * @return staff_state 导购助手状态 1=启用；0=禁用
     */
    public Boolean getStaffState() {
        return staffState;
    }

    /**
     * 导购助手状态 1=启用；0=禁用
     * @param staffState 导购助手状态 1=启用；0=禁用
     */
    public void setStaffState(Boolean staffState) {
        this.staffState = staffState;
    }

    /**
     * 智慧门店code
     * @return smart_store_code 智慧门店code
     */
    public String getSmartStoreCode() {
        return smartStoreCode;
    }

    /**
     * 智慧门店code
     * @param smartStoreCode 智慧门店code
     */
    public void setSmartStoreCode(String smartStoreCode) {
        this.smartStoreCode = smartStoreCode == null ? null : smartStoreCode.trim();
    }

    /**
     * 智慧门店名称
     * @return smart_store_name 智慧门店名称
     */
    public String getSmartStoreName() {
        return smartStoreName;
    }

    /**
     * 智慧门店名称
     * @param smartStoreName 智慧门店名称
     */
    public void setSmartStoreName(String smartStoreName) {
        this.smartStoreName = smartStoreName == null ? null : smartStoreName.trim();
    }

    /**
     * 附近门店是否显示 0:不显示 1:显示
     * @return is_display 附近门店是否显示 0:不显示 1:显示
     */
    public Boolean getIsDisplay() {
        return isDisplay;
    }

    /**
     * 附近门店是否显示 0:不显示 1:显示
     * @param isDisplay 附近门店是否显示 0:不显示 1:显示
     */
    public void setIsDisplay(Boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    /**
     * 门店营业时间
     * @return store_business_time 门店营业时间
     */
    public String getStoreBusinessTime() {
        return storeBusinessTime;
    }

    /**
     * 门店营业时间
     * @param storeBusinessTime 门店营业时间
     */
    public void setStoreBusinessTime(String storeBusinessTime) {
        this.storeBusinessTime = storeBusinessTime == null ? null : storeBusinessTime.trim();
    }

    /**
     * 店铺线上线下标识10:线下 20:线上
     * @return model_type 店铺线上线下标识10:线下 20:线上
     */
    public Integer getModelType() {
        return modelType;
    }

    /**
     * 店铺线上线下标识10:线下 20:线上
     * @param modelType 店铺线上线下标识10:线下 20:线上
     */
    public void setModelType(Integer modelType) {
        this.modelType = modelType;
    }

    /**
     * 营业状态 10：开店申请20：已开业 30：立项终止40：已撤除
     * @return business_status 营业状态 10：开店申请20：已开业 30：立项终止40：已撤除
     */
    public Integer getBusinessStatus() {
        return businessStatus;
    }

    /**
     * 营业状态 10：开店申请20：已开业 30：立项终止40：已撤除
     * @param businessStatus 营业状态 10：开店申请20：已开业 30：立项终止40：已撤除
     */
    public void setBusinessStatus(Integer businessStatus) {
        this.businessStatus = businessStatus;
    }

    /**
     * 店铺面积
     * @return store_size 店铺面积
     */
    public BigDecimal getStoreSize() {
        return storeSize;
    }

    /**
     * 店铺面积
     * @param storeSize 店铺面积
     */
    public void setStoreSize(BigDecimal storeSize) {
        this.storeSize = storeSize;
    }

    /**
     * toString
     * @return String 
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", sysStoreId=").append(sysStoreId);
        sb.append(", sysCompanyId=").append(sysCompanyId);
        sb.append(", sysBrandId=").append(sysBrandId);
        sb.append(", slaveSysBrandId=").append(slaveSysBrandId);
        sb.append(", sysStoreOnlineCode=").append(sysStoreOnlineCode);
        sb.append(", sysStoreOfflineCode=").append(sysStoreOfflineCode);
        sb.append(", storeId=").append(storeId);
        sb.append(", storeName=").append(storeName);
        sb.append(", storePhone=").append(storePhone);
        sb.append(", provinceName=").append(provinceName);
        sb.append(", cityName=").append(cityName);
        sb.append(", areaName=").append(areaName);
        sb.append(", detailedAddress=").append(detailedAddress);
        sb.append(", bizArea=").append(bizArea);
        sb.append(", lng=").append(lng);
        sb.append(", lat=").append(lat);
        sb.append(", storeImgs=").append(storeImgs);
        sb.append(", storeOrcode=").append(storeOrcode);
        sb.append(", storeOrcodeRouteUrl=").append(storeOrcodeRouteUrl);
        sb.append(", distributorName=").append(distributorName);
        sb.append(", storeType=").append(storeType);
        sb.append(", dictionaryCode=").append(dictionaryCode);
        sb.append(", shopOwner=").append(shopOwner);
        sb.append(", status=").append(status);
        sb.append(", onDate=").append(onDate);
        sb.append(", offDate=").append(offDate);
        sb.append(", remark=").append(remark);
        sb.append(", createUserId=").append(createUserId);
        sb.append(", createUserName=").append(createUserName);
        sb.append(", createDate=").append(createDate);
        sb.append(", modifiedUserId=").append(modifiedUserId);
        sb.append(", modifiedUserName=").append(modifiedUserName);
        sb.append(", modifiedDate=").append(modifiedDate);
        sb.append(", valid=").append(valid);
        sb.append(", staffState=").append(staffState);
        sb.append(", smartStoreCode=").append(smartStoreCode);
        sb.append(", smartStoreName=").append(smartStoreName);
        sb.append(", isDisplay=").append(isDisplay);
        sb.append(", storeBusinessTime=").append(storeBusinessTime);
        sb.append(", modelType=").append(modelType);
        sb.append(", businessStatus=").append(businessStatus);
        sb.append(", storeSize=").append(storeSize);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}