/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.thread;

import com.bizvane.connectorservice.thread.VisiableThreadPoolTaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class ExecutorConfig {
    @Value(value="${threadPool.corePoolSize}")
    private int corePoolSize;
    @Value(value="${threadPool.maximumPoolSize}")
    private int maxPoolSize;
    @Value(value="${threadPool.queueCapacity}")
    private int queueCapacity;
    @Value(value="${threadPool.keepAliveTime}")
    private int keepAliveTime;

    @Bean
    public Executor asyncServiceExecutor() {
        VisiableThreadPoolTaskExecutor executor = new VisiableThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setKeepAliveSeconds(this.keepAliveTime);
        executor.setThreadNamePrefix("async-service-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

