/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.serviceImpl.LoginServiceImpl;
import com.bizvane.util.DateUtils;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import com.bizvane.util.tools.StringUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpencardServiceImpl
implements BaseInterface {
    private Logger logger = LoggerFactory.getLogger(OpencardServiceImpl.class);
    @Autowired
    private LoginServiceImpl loginService;

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        this.logger.info("Opencard-----\u300bparams:" + params);
        JSONObject param = new JSONObject(params);
        String phone = param.optString("phone", "");
        String name = param.optString("name", "");
        String levelCode = param.optString("levelCode", "");
        String gender = param.optString("gender", "");
        String birthday = param.optString("birthday");
        String openStoreCode = param.optString("openStoreCode", "");
        String openGuideCode = param.optString("openGuideCode", "");
        String address = param.optString("address");
        String source = param.optString("source", "");
        String qddm = "";
        String qydm = "";
        String dymc = "";
        String vipTypeSql = "select dm,zk from V_CARSET where dm = ?";
        JSONObject vipTypeJson = QueryEngine.queryJSONObject((String)vipTypeSql, (Object[])new Object[]{levelCode});
        if (vipTypeJson == null) {
            this.logger.info("\u4f1a\u5458\u5361:" + levelCode + "\u4e0d\u5b58\u5728");
            return ResultUtil.disposeResult((String)"-1", (String)("\u4f1a\u5458\u5361:" + levelCode + "\u4e0d\u5b58\u5728")).toString();
        }
        this.logger.info("\u67e5\u8be2\u4f1a\u5458\u5361code\u4fe1\u606f:{}", (Object)vipTypeJson);
        if (StringUtil.isNotNull((Object)openStoreCode)) {
            String storeSql = "select qddm,qydm from kehu where khdm = ?";
            JSONObject storeJson = QueryEngine.queryJSONObject((String)storeSql, (Object[])new Object[]{openStoreCode});
            if (storeJson == null) {
                return ResultUtil.disposeResult((String)"-1", (String)("\u95e8\u5e97:" + openStoreCode + "\u4e0d\u5b58\u5728")).toString();
            }
            this.logger.info("\u83b7\u53d6\u5f00\u5361\u95e8\u5e97\u4fe1\u606f:{}", (Object)storeJson);
            qddm = storeJson.optString("qddm");
            qydm = storeJson.optString("qydm");
        }
        if (StringUtil.isNotNull((Object)openGuideCode)) {
            String guideSql = "select dymc from dianyuan where dydm = ?";
            JSONObject guideJson = QueryEngine.queryJSONObject((String)guideSql, (Object[])new Object[]{openGuideCode});
            if (guideJson == null) {
                return ResultUtil.disposeResult((String)"-1", (String)("\u5bfc\u8d2d:" + openGuideCode + "\u4e0d\u5b58\u5728")).toString();
            }
            dymc = guideJson.optString("dymc");
        }
        String gkdm = "GK" + openStoreCode;
        String sex = "1".equals(gender) ? "\u7537" : "\u5973";
        String sr = null;
        try {
            sr = DateUtils.ymdToYmdHsm(birthday);
        }
        catch (Exception e) {
            return ResultUtil.disposeResult((String)"-1", (String)("\u751f\u65e5\u65e5\u671f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38:" + e.getMessage())).toString();
        }
        String yb = "";
        String sj = phone;
        String dz = address;
        String queryVpIdSql = "select top 1 dm+1 AS c_dm from v_vipset where dm like '30%' order by dm desc";
        String dm = "";
        try {
            JSONObject insertVpIdObj = QueryEngine.queryJSONObject((String)queryVpIdSql, (Object[])new Object[0]);
            if (insertVpIdObj == null) {
                dm = "30000100";
            }
            dm = insertVpIdObj.optString("c_dm");
        }
        catch (Exception e) {
            return ResultUtil.disposeResult((String)"-1", (String)("\u5f00\u5361\u5931\u8d25\uff0c\u83b7\u53d6VIP\u7f16\u53f7\u65f6\u5f02\u5e38\uff1a" + e.getMessage())).toString();
        }
        String queryVpCountSql = "select count(0) from vpzcdmx where vpdm = ?";
        try {
            int count = QueryEngine.queryCount((String)queryVpCountSql, (Object[])new Object[]{dm});
            if (count != 1) {
                return ResultUtil.disposeResult((String)"-1", (String)"\u5f00\u5361\u5931\u8d25\uff0c\u7ebf\u4e0b\u4f1a\u5458\u5236\u6210\u5355\u6570\u636e\u5f02\u5e38").toString();
            }
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u4f1a\u5458\u5236\u6210\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            ResultUtil.disposeResult((String)"-1", (String)("\u5f00\u5361\u5931\u8d25\uff0c\u67e5\u8be2\u4f1a\u5458\u5236\u6210\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage())).toString();
        }
        String queryCustomerSql = "select dm from V_CUSTOMER where sj = ?";
        JSONObject queryCustomerJson = QueryEngine.queryJSONObject((String)queryCustomerSql, (Object[])new Object[]{phone});
        try {
            if (queryCustomerJson != null) {
                gkdm = queryCustomerJson.optString("dm", "");
                String updateCustOmerStoreSql = "update V_CUSTOMER set ckdm = ?, qddm = ?, qydm = ?, hasvip = ?, jdr = ?, xgr = ?, xgrq = GETDATE() where dm = ?";
                QueryEngine.doUpdate((String)updateCustOmerStoreSql, (Object[])new Object[]{openStoreCode, qddm, qydm, dm, dymc, dymc, gkdm});
            } else {
                this.logger.info("\u65b0\u589eipos_customer\u8868\u4fe1\u606f");
                String queryCodeSql = "select top 1 right(dm,6)+1 as code from v_customer where dm like ? order by dm desc";
                JSONObject insertGkIdObj = QueryEngine.queryJSONObject((String)queryCodeSql, (Object[])new Object[]{gkdm + "%"});
                this.logger.info("\u5f53\u524d\u987e\u5ba2\u8868\u4e2d\u8be5\u95e8\u5e97\u7684\u6700\u5927\u7f16\u53f7\uff1a" + insertGkIdObj);
                if (insertGkIdObj == null) {
                    gkdm = gkdm + "000001";
                } else {
                    Integer code = insertGkIdObj.optInt("code");
                    gkdm = gkdm + String.format("%06d", code);
                }
                String insertCustomerSql = "insert into V_CUSTOMER (dm,gkmc,sex,sr,qydm,qddm,ckdm,jdrq,xgrq,xfje,xfsl,dqjf,dz,sj,hasvip,jdr,xgr) values(?,?,?,?,?,?,?,GETDATE(),GETDATE(),0,0,0,?,?,?,?,?)";
                int num = QueryEngine.doSave((String)insertCustomerSql, (Object[])new Object[]{gkdm, name, sex, sr, qydm, qddm, openStoreCode, address, phone, dm, dymc, dymc});
                if (num > 0) {
                    this.logger.info("\u65b0\u589eipos_customer\u8868\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u5f00\u5361\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return ResultUtil.disposeResult((String)"-1", (String)("\u5f00\u5361\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage())).toString();
        }
        String insertVipSetSql = "insert into v_vipset(dm,mc,gkdm,xldm,kldm,lbdm,qddm,qydm,ckdm,qybj,tybj,qyrq,jdrq,tyrq,zk,xfje,xfsl,qyjf,jfje,dqjf,zk2,zk_limit,fkr,byzd21,byzd5,byzd6)  values(?,?,?,?,?,'0',?,?,?,'1','0',getdate(),getdate(),dateadd(YYYY,10,getdate()),1,0,0,0,1,0,0.9,1,?,1,?,?)";
        try {
            QueryEngine.doSave((String)insertVipSetSql, (Object[])new Object[]{dm, name, gkdm, levelCode, levelCode, qddm, qydm, openStoreCode, dymc, dymc, dymc});
            this.logger.info("\u65b0\u589ev_vipset\u8868\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.info("\u5f00\u5361\u5931\u8d25\uff0c\u63d2\u5165v_vipset\u5f02\u5e38\uff1a" + e.getMessage());
            return ResultUtil.disposeResult((String)"-1", (String)("\u5f00\u5361\u5931\u8d25\uff0c\u63d2\u5165v_vipset\u5f02\u5e38\uff1a" + e.getMessage())).toString();
        }
        String updateVipSql = "update VPZCDMX set state = 2 where vpdm = ?";
        try {
            QueryEngine.doUpdate((String)updateVipSql, (Object[])new Object[]{dm});
        }
        catch (Exception e) {
            this.logger.info("\u5f00\u5361\u5931\u8d25\uff0c\u66f4\u6539\u4f1a\u5458\u5236\u6210\u5355\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
            return ResultUtil.disposeResult((String)"-1", (String)("\u5f00\u5361\u5931\u8d25\uff0c\u66f4\u6539\u4f1a\u5458\u5236\u6210\u5355\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage())).toString();
        }
        JSONObject resultJson = this.loginService.getResultJson(phone);
        resultJson.put("firstandingCheck", (Object)"0");
        resultJson.put("phone", (Object)phone);
        return ResultUtil.disposeResult((String)"0", (String)"\u7ebf\u4e0b\u4f1a\u5458\u5f00\u5361\u6210\u529f", (JSONObject)resultJson).toString();
    }
}

