/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import com.bizvane.util.tools.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements BaseInterface {
    private Logger logger = LoggerFactory.getLogger(LoginServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) {
        this.logger.info("Login-----\u300bparams:" + params);
        JSONObject param = new JSONObject(params);
        String phone = param.optString("phone", "");
        String openStoreCode = param.optString("openStoreCode", "");
        String openGuideCode = param.optString("openGuideCode", "");
        if (StringUtil.isNull((Object)phone)) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        String sql = "select c.ckdm c_store, v.ckdm v_store, v.byzd17 v_guide, c.dm c_dm, v.dm v_dm from V_CUSTOMER c JOIN V_VIPSET v on v.gkdm = c.dm where c.sj = ? and v.tybj = 0";
        JSONObject vipId = QueryEngine.queryJSONObject((String)sql, (Object[])new Object[]{phone});
        if (vipId == null) {
            return ResultUtil.disposeResult((String)"8888", (String)"\u7ebf\u4e0b\u6ca1\u6709\u4f1a\u5458,\u9700\u8981\u91cd\u65b0\u5f00\u5361").toString();
        }
        this.logger.info("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f:{}", (Object)vipId);
        String c_dm = vipId.optString("c_dm");
        String v_dm = vipId.optString("v_dm");
        JSONObject resultJson = this.getResultJson(phone);
        return ResultUtil.disposeResult((String)"0", (String)"\u7ed1\u5361\u6210\u529f", (JSONObject)resultJson).toString();
    }

    public JSONObject getResultJson(String phone) {
        String vipSql = "SELECT\n\tv.kldm AS levelCode,\n\tv.dm AS offlineCardNo,\n\tv.dqjf AS countIntegral,\n\tv.mc AS name,\n\tc.sex AS gender,\n\tc.sr AS birthday,\n\tc.dz AS address,\n\tc.ckdm AS openStoreCode,\n\tc.ckdm AS serviceStoreCode,\n\tv.byzd17 AS openGuideCode,\n\tv.byzd17 AS serviceGuideCode,\n\tv.dm AS erpId \nFROM\n\tv_customer c\n\tJOIN v_vipset v ON c.dm = v.gkdm \nWHERE\n\tc.sj = ? and v.tybj = 0";
        JSONObject vipInfo = QueryEngine.queryJSONObject((String)vipSql, (Object[])new Object[]{phone});
        this.logger.info("\u67e5\u8be2\u6240\u6709\u4f1a\u5458\u4fe1\u606f:{}", (Object)vipInfo);
        JSONObject resultJson = new JSONObject();
        resultJson.put("levelCode", (Object)vipInfo.optString("levelcode"));
        resultJson.put("offlineCardNo", (Object)vipInfo.optString("offlinecardno"));
        resultJson.put("countIntegral", (Object)vipInfo.optString("countintegral"));
        resultJson.put("effectiveTime", (Object)"0");
        resultJson.put("name", (Object)vipInfo.optString("name"));
        resultJson.put("address", (Object)vipInfo.optString("address"));
        resultJson.put("openStoreCode", (Object)vipInfo.optString("openstorecode"));
        resultJson.put("openGuideCode", (Object)vipInfo.optString("openguidecode"));
        resultJson.put("erpId", (Object)vipInfo.optString("erpid"));
        if (vipInfo.optString("birthday").length() != 0) {
            SimpleDateFormat ymd = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date time = sdf.parse(vipInfo.optString("birthday"));
                String birthday = ymd.format(time);
                resultJson.put("birthday", (Object)birthday);
            }
            catch (ParseException e) {
                this.logger.info("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u83b7\u53d6\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        if (vipInfo.optString("gender").length() != 0) {
            resultJson.put("gender", (Object)("\u7537".equals(vipInfo.optString("gender")) ? "1" : "0"));
        }
        return resultJson;
    }
}

