/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AddCouponDefToErpServiceImpl
implements BaseInterface {
    Logger logger = LoggerFactory.getLogger(AddCouponDefToErpServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        try {
            this.logger.info("AddCouponDefToErp --> param:" + params);
            JSONObject param = new JSONObject(params);
            String erpCouponDefinitionCode = param.optString("erpCouponDefinitionCode", "");
            String couponName = param.optString("couponName", "");
            Integer preferentialType = param.optInt("preferentialType");
            String createDate = param.optString("createDate", "");
            BigDecimal money = param.optBigDecimal("money", new BigDecimal(0));
            Long validDateStart = param.optLong("validDateStart");
            Long validDateEnd = param.optLong("validDateEnd");
            Integer validType = param.optInt("validType");
            if (preferentialType != 1) {
                this.logger.info("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u4f70\u5229\u8c6a\u7ebf\u4e0b\u7cfb\u7edf\u53ea\u652f\u6301\u73b0\u91d1\u5238");
                return ResultUtil.disposeResult((String)"-1", (String)"\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u4f70\u5229\u8c6a\u7ebf\u4e0b\u7cfb\u7edf\u53ea\u652f\u6301\u73b0\u91d1\u5238").toString();
            }
            String queryCzklbByLbdm = "select count(0) from LQLB where LBDM = ?";
            try {
                int queryCzklbNum = QueryEngine.queryCount((String)queryCzklbByLbdm, (Object[])new Object[]{erpCouponDefinitionCode});
                if (queryCzklbNum != 0) {
                    this.logger.info("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u8be5\u5238\u53f7\u7ebf\u4e0b\u5df2\u5b58\u5728");
                    return ResultUtil.disposeResult((String)"-1", (String)"\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u8be5\u5238\u53f7\u7ebf\u4e0b\u5df2\u5b58\u5728").toString();
                }
            }
            catch (Exception e) {
                this.logger.info("\u67e5\u8be2\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
                return ResultUtil.disposeResult((String)"-1", (String)("\u67e5\u8be2\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage())).toString();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = sdf.format(new Date());
            String SQ_S = null;
            String SQ_E = null;
            if (validType != 1) {
                this.logger.info("\u4f70\u5229\u8c6a\u7ebf\u4e0b\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u671f\u533a\u95f4\u4ee5\u5916\u7684\u6709\u6548\u671f\u7c7b\u578b");
                return ResultUtil.disposeResult((String)"-1", (String)"\u4f70\u5229\u8c6a\u7ebf\u4e0b\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u671f\u533a\u95f4\u4ee5\u5916\u7684\u6709\u6548\u671f\u7c7b\u578b").toString();
            }
            SQ_S = sdf.format(new Date(validDateStart));
            SQ_E = sdf.format(new Date(validDateEnd));
            String zcdbh = this.getDjbh("LQZCD", "CZKZCD");
            String insertCzklbSql = "insert into LQLB  (LBDM,LBMC,XZDM,RQ_S,RQ_E,XFJE,FSJE,TZSY,BYZD1,BYZD2,BYZD3,BYZD4,GLVIP)  VALUES(?,?,2,?,?,?,0,0,0,0,1,1,1) ";
            try {
                this.logger.info("\u65b0\u589e\u5238\u7c7b\u578b\u8868LQLB\u8868\u4fe1\u606f");
                QueryEngine.doSave((String)insertCzklbSql, (Object[])new Object[]{erpCouponDefinitionCode, couponName, SQ_S, SQ_E, money});
            }
            catch (Exception e) {
                this.logger.info("\u65b0\u589e\u5238\u7c7b\u578b\u53f7:" + erpCouponDefinitionCode + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
                return ResultUtil.disposeResult((String)"-1", (String)("\u65b0\u589e\u5238\u7c7b\u578b\u53f7:" + erpCouponDefinitionCode + "\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage())).toString();
            }
            String insertCzkzcdSql = "insert into LQZCD(DJBH,RQ,XZDM,LBDM,RQ_S,RQ_E,KQZ,XFJE,JZ,JZR,JZRQ,ZDR,RQ_4,BYZD1,BYZD5,BYZD11,BYZD12) VALUES(?,getDate(),2,?,?,?,'CZKZCD',?,1,'\u7cfb\u7edf\u7ba1\u7406\u5458',getDate(),'\u7cfb\u7edf\u7ba1\u7406\u5458',getDate(),0,0,1,'\u7cfb\u7edf\u7ba1\u7406\u5458')";
            try {
                QueryEngine.doSave((String)insertCzkzcdSql, (Object[])new Object[]{zcdbh, erpCouponDefinitionCode, SQ_S, SQ_E, money});
            }
            catch (Exception e) {
                this.logger.info("\u5355\u5f20\u53d1\u5238\u5931\u8d25,\u63d2\u5165LQZCD\u8868\u5f02\u5e38:" + e.getMessage());
                return ResultUtil.disposeResult((String)"-1", (String)("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25,\u63d2\u5165LQZCD\u8868\u5f02\u5e38\uff1a" + e.getMessage())).toString();
            }
            String tfdbh = this.getDjbh("LQTFD", "CZKTFD");
            String czkzcdtf = "insert into LQTFD(DJBH,RQ,QDDM,CKDM,XZDM,LBDM,JE,JZ,JZR,JZRQ,ZDR,RQ_4,BYZD1,BYZD3) values(?,getDate(),'000','AB0001',1,?,0,1,'\u7cfb\u7edf\u7ba1\u7406\u5458',getDate(),'\u7cfb\u7edf\u7ba1\u7406\u5458',getDate(),0,0)";
            this.logger.info("\u65b0\u589eLQTFD");
            try {
                QueryEngine.doSave((String)czkzcdtf, (Object[])new Object[]{tfdbh, erpCouponDefinitionCode});
            }
            catch (Exception e) {
                this.logger.info("\u5355\u5f20\u53d1\u5238\u5931\u8d25\uff0c\u63d2\u5165LQTFD\u8868\u5f02\u5e38:" + e.getMessage());
                return ResultUtil.disposeResult((String)"-1", (String)("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u63d2\u5165LQTFD\u8868\u5f02\u5e38:" + e.getMessage())).toString();
            }
            String xsdbh = this.getDjbh("LQXSD", "CZKXSD");
            String czkxsdtf = "insert into LQXSD(DJBH,RQ,QDDM,CKDM,XZDM,LBDM,ZS,JZ,JZR,JZRQ,JS,ZDR,RQ_4,BYZD1,BYZD3) values(?,getDate(),'000','AB0001',1,?,0,1,'\u7cfb\u7edf\u7ba1\u7406\u5458',getDate(),0,'\u7cfb\u7edf\u7ba1\u7406\u5458',getDate(),0,0)";
            this.logger.info("\u65b0\u589eLQTFD");
            try {
                QueryEngine.doSave((String)czkxsdtf, (Object[])new Object[]{xsdbh, erpCouponDefinitionCode});
            }
            catch (Exception e) {
                this.logger.info("\u5355\u5f20\u53d1\u5238\u5931\u8d25\uff0c\u63d2\u5165LQXSD\u8868\u5f02\u5e38:" + e.getMessage());
                return ResultUtil.disposeResult((String)"-1", (String)("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u63d2\u5165LQXSD\u8868\u5f02\u5e38:" + e.getMessage())).toString();
            }
            return ResultUtil.disposeResult((String)"0", (String)("\u65b0\u589e\u5238\u7c7b\u578b\u53f7:" + erpCouponDefinitionCode + "\u6210\u529f")).toString();
        }
        catch (Exception e) {
            this.logger.info("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return ResultUtil.disposeResult((String)"-1", (String)("\u65b0\u589e\u5238\u7c7b\u578b\u53f7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage())).toString();
        }
    }

    public String getDjbh(String tableName, String prefix) throws Exception {
        String getDjbhSql = "select top 1 right(djbh,6)+1 as djbh from " + tableName + " where DJBH like '" + prefix + "%' order by djbh desc";
        String djbh = "";
        try {
            JSONObject getDjbhRrsult = QueryEngine.queryJSONObject((String)getDjbhSql, (Object[])new Object[0]);
            djbh = getDjbhRrsult != null ? prefix + String.format("%06d", getDjbhRrsult.optInt("djbh")) : prefix + "000001";
            return djbh;
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2" + tableName + "\u8868\u7f16\u53f7\u5931\u8d25,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            return ResultUtil.disposeResult((String)"-1", (String)("\u67e5\u8be2" + tableName + "\u8868\u7f16\u53f7\u5931\u8d25,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage())).toString();
        }
    }
}

