/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RechargeRecordServiceImpl
implements BaseInterface {
    private Logger logger = LoggerFactory.getLogger(RechargeRecordServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        this.logger.info("rechargeRecord-----\u300bparams:" + params);
        JSONObject inObject = new JSONObject(params);
        String petCard = inObject.optString("petCard");
        String serialNumber = inObject.optString("serialNumber");
        String wxSerialNumber = inObject.optString("wxSerialNumber");
        String vipId = inObject.optString("vipId");
        String vipName = inObject.optString("vipName");
        String vipPhone = inObject.optString("vipPhone");
        String OutTradeNo = inObject.optString("outTradeNo");
        BigDecimal rechargeMoney = inObject.optBigDecimal("rechargeMoney", new BigDecimal(0));
        BigDecimal rewardMoney = inObject.optBigDecimal("rewardMoney", new BigDecimal(0));
        Long validTime = inObject.getLong("validDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String validDate = sdf.format(new Date(validTime));
        this.logger.info("vipName\u8f6c\u6362\u524d:" + vipName);
        vipName = vipName.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "");
        this.logger.info("vipName\u8f6c\u6362\u7f16\u7801\u540e:" + vipName);
        if (vipName.contains(" ")) {
            vipName = vipName.replace(" ", "");
        }
        this.logger.info("vipName\u8f6c\u6362\u7a7a\u683c\u540e:" + vipName);
        if (StringUtils.isEmpty((Object)petCard)) {
            this.logger.info("\u65b0\u589e\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u50a8\u84c4\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u50a8\u84c4\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        if (StringUtils.isEmpty((Object)vipId)) {
            this.logger.info("\u65b0\u589e\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        if ("".equals(rechargeMoney.toString()) || "".equals(rewardMoney.toString())) {
            this.logger.info("\u65b0\u589e\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        if (StringUtils.isEmpty((Object)validDate)) {
            this.logger.info("\u65b0\u589e\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        String isExistsSql = " select count(1) from recharge_card_save t where t.recharge_no = ?";
        int count = QueryEngine.queryCount((String)isExistsSql, (Object[])new Object[]{serialNumber});
        if (count > 0) {
            return ResultUtil.disposeResult((String)"0", (String)"\u8be5\u6d41\u6c34\u53f7\u7ebf\u4e0b\u5df2\u5b58\u5728").toString();
        }
        StringBuffer cardSaveNoSql = new StringBuffer();
        String isExistsSqlCard = " select count(1) from recharge_card t where t.recharge_card_id = ?";
        int countCard = QueryEngine.queryCount((String)isExistsSqlCard, (Object[])new Object[]{petCard});
        if (countCard > 0) {
            String queryMoneySql = "select t.amount,t.give_amount from recharge_card t where t.recharge_card_id = ?";
            JSONObject content = QueryEngine.queryJSONObject((String)queryMoneySql, (Object[])new Object[]{petCard});
            if (content != null && content.length() != 0) {
                BigDecimal rechargeMoneyCount = content.optBigDecimal("amount", new BigDecimal(0));
                this.logger.info("\u50a8\u503c\u5361\u539f\u672c\u91d1\u4f59\u989d\uff1a" + rechargeMoneyCount);
                BigDecimal giveAmountCount = content.optBigDecimal("give_amount", new BigDecimal(0));
                this.logger.info("\u50a8\u503c\u5361\u539f\u8d60\u9001\u91d1\u989d\uff1a" + giveAmountCount);
                BigDecimal rechargeMoneySum = rechargeMoneyCount.add(rechargeMoney);
                BigDecimal giveAmountSum = giveAmountCount.add(rewardMoney);
                String updateMoneySql = "update recharge_card t set t.amount = ?,t.give_amount = ?,t.t_bizmd = sysdate(), t.valid_date = ? where t.recharge_card_id = ? ";
                QueryEngine.doUpdate((String)updateMoneySql, (Object[])new Object[]{rechargeMoneySum, giveAmountSum, validDate, petCard});
                this.logger.info("\u66f4\u65b0\u50a8\u503c\u5361\u91d1\u989d\uff0c\u50a8\u503c\u5361\u53f7\u4e3a\uff1a" + petCard);
            }
        } else {
            cardSaveNoSql.append(" insert into recharge_card (recharge_card_id,vip_id,name_vip,mobile_vip,amount,give_amount,");
            cardSaveNoSql.append(" card_status,t_bizcr,t_bizmd,valid,valid_date)");
            cardSaveNoSql.append(" values(?,?,?,?,?,?,");
            cardSaveNoSql.append(" '1',sysdate(),sysdate(),'1',?)");
            int j = QueryEngine.doSave((String)cardSaveNoSql.toString(), (Object[])new Object[]{petCard, vipId, vipName, vipPhone, rechargeMoney, rewardMoney, validDate});
            if (j == 0) {
                return ResultUtil.disposeResult((String)"-1", (String)"\u65b0\u589e\u50a8\u503c\u5361\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25").toString();
            }
        }
        cardSaveNoSql.setLength(0);
        cardSaveNoSql.append(" insert into recharge_card_save( ");
        cardSaveNoSql.append(" RECHARGE_NO,MERCHANT_NO,VIP_ID,NAME_VIP,MOBILE_VIP, ");
        cardSaveNoSql.append(" RECHARGE_CARD_ID,AMOUNT,GIVE_AMOUNT,OUT_TRADE_NO,T_BIZCR,T_BIZMD,VALID) ");
        cardSaveNoSql.append(" values(?,?,?,?,?,");
        cardSaveNoSql.append(" ?,?,?,?,sysdate(),sysdate(),'1')");
        int i = QueryEngine.doSave((String)cardSaveNoSql.toString(), (Object[])new Object[]{serialNumber, wxSerialNumber, vipId, vipName, vipPhone, petCard, rechargeMoney, rewardMoney, OutTradeNo});
        if (i == 0) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u65b0\u589e\u50a8\u503c\u5361\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25").toString();
        }
        return ResultUtil.disposeResult((String)"0", (String)"\u65b0\u589e\u50a8\u503c\u5361\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u6210\u529f").toString();
    }
}

