/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.BusinessTypeEnum;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdjustIntegralServiceImpl
implements BaseInterface {
    Logger logger = LoggerFactory.getLogger(AdjustIntegralServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        this.logger.info("adjustIntegral-----\u300bparams:" + params);
        JSONObject inObject = new JSONObject(params);
        String orderBillNo = inObject.optString("orderBillNo");
        String offlineCardNo = inObject.optString("offlineCardNo");
        int changeIntegral = inObject.optInt("changeIntegral", 0);
        String changeType = inObject.optString("changeType");
        String businessType = inObject.optString("businessType");
        String integralType = BusinessTypeEnum.getIntegralType(businessType);
        String detail = inObject.optString("detail");
        String storeId = inObject.optString("storeId");
        Double pointsAmount = inObject.optDouble("pointsAmount", 0.0);
        if (new Double(0.0).equals(pointsAmount)) {
            pointsAmount = changeIntegral;
        }
        String source = inObject.optString("source");
        String pointsIdUnique = inObject.optString("pointsIdUnique");
        Object interfaceParam = null;
        String userConditionByCardNoSql = "select c.VIP_ID,c.points from c_client_vip c where c.card_no_vip = ?";
        JSONObject user = QueryEngine.queryJSONObject((String)userConditionByCardNoSql, (Object[])new Object[]{offlineCardNo});
        this.logger.info("user:" + JSON.toJSONString((Object)user));
        int points = user.optInt("points");
        this.logger.info("points\uff1a" + points);
        String vip_id = user.optString("vip_id");
        this.logger.info("vip_id:" + vip_id);
        int points_now = points + changeIntegral;
        this.logger.info("\u8ba1\u7b97\u603b\u79ef\u5206\u4e3a:{}", (Object)points_now);
        String code = pointsIdUnique;
        String checkExistSql = "SELECT COUNT(1)   from points_detail where id =?";
        int count = QueryEngine.queryCount((String)checkExistSql, (Object[])new Object[]{pointsIdUnique});
        if (count > 0) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u79ef\u5206\u8c03\u6574\u5931\u8d25\uff0c\u6570\u636e\u91cd\u590d").toString();
        }
        this.logger.info("\u65b0\u589e\u4f1a\u5458\u79ef\u5206\u6d41\u6c34");
        String insertPointsSql = "INSERT INTO points_detail (\n\tid,\n\tvip_id,\n\tdocdate,\n\tpoints,\n\tsource,\n\tvaliddate,\n\tdescription,\n\tt_cr,\n\tt_md,\n\tis_valis,\n\tdocno,\n\tintegral_type,\n\tintegral_type_name,\n\tPOINTS_AMOUNT,\n\tSTORE_ID\n)\nVALUES\n\t(\n\t\t?,?, sysdate() ,?, ?,\n\t\tsysdate() ,?, sysdate(),\n\t\tsysdate(),\n\t\t'Y' ,?,?,?,?,?\n\t)";
        QueryEngine.doUpdate((String)insertPointsSql, (Object[])new Object[]{code, vip_id, changeIntegral, source, detail, orderBillNo, integralType, businessType, pointsAmount, storeId});
        String pointDetailId = code;
        this.logger.info("\u66f4\u65b0\u4f1a\u5458\u603b\u79ef\u5206");
        String updateAllPointByCardNoSql = "update c_client_vip set points = ? where vip_id = ?";
        QueryEngine.doUpdate((String)updateAllPointByCardNoSql, (Object[])new Object[]{points_now, vip_id});
        JSONObject resultJson = new JSONObject();
        resultJson.put("changeIntegral", changeIntegral);
        resultJson.put("offlineCardNo", (Object)offlineCardNo);
        resultJson.put("docNo", (Object)orderBillNo);
        resultJson.put("integralAdjustId", (Object)pointDetailId);
        this.logger.info("\u79ef\u5206\u8c03\u6574\u6210\u529f,integralAdjustId:" + pointDetailId);
        return ResultUtil.disposeResult((String)"0", (String)"\u79ef\u5206\u8c03\u6574\u6210\u529f!", (JSONObject)resultJson).toString();
    }
}

