/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.util;

public class BrandUtil {
    private static final String BRAND_UNDERLINE_JXPDM = "JXP001";
    private static final String BRAND_UNDERLINE_CTDM = "CANTORP";
    private static final String BRAND_UNDERLINE_JEEPDM = "Jeep";
    private static final String BRAND_UNDERLINE_JEEP = "Jeep";
    private static final String BRAND_UNDERLINE_CT_VPDM = "CT";
    private static final String BRAND_UNDERLINE_JXP = "JXP";
    private static final String BRAND_ONLINE_JEEP = "Jeep";
    private static final String BRAND_ONLINE_CT = "CANTORP";
    private static final String BRAND_ONLINE_JXP = "P40062";
    private static final String BRAND_JEEP_PP_ID = "296769";
    private static final String BRAND_CT_PP_ID = "2";
    private static final String BRAND_JXP_PP_ID = "5";
    private static final String BRAND_JEEP = "\u54c1\u724c[[008]-Jeep\u4f11\u95f2]";
    private static final String BRAND_CT = "\u54c1\u724c[[004]-\u5409\u666e\u6237\u5916]";
    private static final String BRAND_JXP = "\u54c1\u724c[[001]-CANTORP]";

    public static int getXlId(String brand) {
        if (BRAND_ONLINE_JXP.equals(brand)) {
            return 43;
        }
        if ("Jeep".equals(brand)) {
            return 61;
        }
        return 62;
    }

    public static String getBrand(String brand) {
        String pp_id = null;
        switch (brand) {
            case "P40062": {
                pp_id = BRAND_JXP;
                break;
            }
            case "CANTORP": {
                pp_id = BRAND_CT;
                break;
            }
            case "Jeep": {
                pp_id = BRAND_JEEP;
                break;
            }
            default: {
                pp_id = BRAND_JXP_PP_ID;
            }
        }
        return pp_id;
    }

    public static String getBrandPpId(String brand) {
        String pp_id = null;
        switch (brand) {
            case "P40062": {
                pp_id = BRAND_JXP_PP_ID;
                break;
            }
            case "CANTORP": {
                pp_id = BRAND_CT_PP_ID;
                break;
            }
            case "Jeep": {
                pp_id = BRAND_JEEP_PP_ID;
                break;
            }
            default: {
                pp_id = BRAND_JXP_PP_ID;
            }
        }
        return pp_id;
    }

    public static String getBrandDm(String brand) {
        String xldm = null;
        switch (brand) {
            case "P40062": {
                xldm = BRAND_UNDERLINE_JXPDM;
                break;
            }
            case "CANTORP": {
                xldm = "CANTORP";
                break;
            }
            case "Jeep": {
                xldm = "Jeep";
                break;
            }
            default: {
                xldm = BRAND_UNDERLINE_JXPDM;
            }
        }
        return xldm;
    }

    public static String getBrandGkdm(String brand, String gkdm) {
        String vpdm = null;
        switch (brand) {
            case "Jeep": {
                vpdm = "Jeep" + gkdm;
                break;
            }
            case "CANTORP": {
                vpdm = BRAND_UNDERLINE_CT_VPDM + gkdm;
                break;
            }
            case "P40062": {
                vpdm = BRAND_UNDERLINE_JXP + gkdm;
                break;
            }
        }
        return vpdm;
    }
}

