/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.util;

import com.bizvane.util.tools.LoggerFactory;
import com.bizvane.util.tools.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.json.JSONObject;
import org.slf4j.Logger;

public final class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class, (String)"DateUtils");

    public static String noToTime(String no) {
        String formats = "yyyy/MM/dd HH:mm:ss";
        Long timestamp = Long.parseLong(no) * 1000L;
        String date = new SimpleDateFormat(formats, Locale.CHINA).format(new Date(timestamp));
        return date;
    }

    public static String getStamp() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String stamp = dateFormat.format(date);
        return stamp;
    }

    public static String stampToDate(String stamp) {
        String date = "";
        if (StringUtil.isNotNull((Object)stamp)) {
            Date date1 = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            try {
                date1 = dateFormat.parse(stamp);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            date = format.format(date1);
        }
        return date;
    }

    public static String stampToYMD(String stamp) {
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(Long.valueOf(stamp) * 1000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(instance.getTime());
    }

    public static String ymdToStamp(String stamp) {
        if (StringUtil.isNull((Object)stamp)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            Date parse = format.parse(stamp);
            Calendar instance = Calendar.getInstance();
            instance.setTime(parse);
            String stampStr = instance.getTimeInMillis() / 1000L + "";
            return stampStr;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static String ymdToM_d(String stamp) {
        if (StringUtil.isNull((Object)stamp)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat format1 = new SimpleDateFormat("MM-dd");
        try {
            Date parse = format.parse(stamp);
            return format1.format(parse);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String dateToStamp(String date) {
        String stamp = "";
        if (StringUtil.isNotNull((Object)date)) {
            Date date1 = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            try {
                date1 = dateFormat.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            stamp = format.format(date1);
        }
        return stamp;
    }

    public static String toOnline(String gender) {
        String genderJudge = "";
        genderJudge = gender.equals("\u7537") ? "1" : (gender.equals("\u5973") ? "0" : "");
        return genderJudge;
    }

    public static String toOffline(String gender) {
        String genderJudge = "";
        genderJudge = gender.equals("1") ? "\u7537" : (gender.equals("0") ? "\u5973" : "");
        return genderJudge;
    }

    public static String getYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        return sdf.format(date);
    }

    public static String sendRequest_buff(String apiURL, String params1, JSONObject data, String method1, boolean keepAlive1) throws Exception {
        int charset1;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        logger.info("url->" + apiURL);
        Authenticator.setDefault(new MyAuthenticator());
        if (StringUtil.isNotNull((Object)params1)) {
            logger.info("params1 :" + (params1.length() > 3000 ? params1.substring(0, 3000) : params1));
        }
        method1 = StringUtil.valueOf((Object)method1, (String)"POST");
        HttpURLConnection conn1 = (HttpURLConnection)new URL(apiURL).openConnection();
        conn1.setRequestMethod(method1.toUpperCase());
        conn1.setRequestProperty("Authorization", data.optString("data", ""));
        conn1.setRequestProperty("Accept-Charset", "UTF-8");
        conn1.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        if (keepAlive1) {
            conn1.setRequestProperty("Connection", "Keep-Alive");
            conn1.setConnectTimeout(60000);
        } else {
            conn1.setConnectTimeout(6000);
        }
        conn1.setDoInput(true);
        if ("post".equalsIgnoreCase(method1)) {
            conn1.setUseCaches(false);
        }
        if (StringUtil.isNotNull((Object)params1)) {
            conn1.setDoOutput(true);
            conn1.getOutputStream().write(params1.getBytes("utf-8"));
        }
        conn1.connect();
        if (conn1.getResponseCode() != 200) {
            logger.error("server status->" + conn1.getResponseCode());
            throw new Exception("\u8bf7\u6c42url\u5931\u8d25");
        }
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        bis = new BufferedInputStream(conn1.getInputStream());
        boolean charset = false;
        while ((charset1 = bis.read(buf)) != -1) {
            baos.write(buf, 0, charset1);
        }
        logger.info("chareset:" + conn1.getContentType());
        String charset2 = DateUtils.getChareset(conn1.getContentType());
        String resultString = baos.toString(charset2);
        logger.info("-------->resultString:" + baos.toString());
        conn1.disconnect();
        logger.info("RestUtils result-->" + resultString);
        return resultString;
    }

    public static String getChareset(String contentType) {
        int i = contentType == null ? -1 : contentType.indexOf("charset=");
        return i == -1 ? "UTF-8" : contentType.substring(i + 8);
    }

    static class MyAuthenticator
    extends Authenticator {
        MyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String username = "guest";
            String password = "guest";
            return new PasswordAuthentication(username, password.toCharArray());
        }
    }
}

