/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.common.ApiException;
import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.DateUtils;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import com.bizvane.util.tools.StringUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements BaseInterface {
    private Logger logger = LoggerFactory.getLogger(LoginServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) {
        JSONObject param = new JSONObject(params);
        String openId = param.optString("openId", "");
        String unionId = param.optString("unionId", "");
        String phone = param.optString("phone", "");
        String openStoreCode = param.optString("openStoreCode", "");
        String openGuideCode = param.optString("openGuideCode", "");
        String source = param.optString("source", "");
        if (StringUtil.isNull((Object)phone)) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        String sql = "SELECT\n\tb.dj_zd as 'c_openStoreId',\n\tb.zd_id as 'c_serviceStoreId',\n\tb.jddy_id as 'c_openGuideId',\n\tb.dy_id as 'c_serviceGuideId',\n\tv.zd_id as 'v_openStoreId',\n\tv.sszd_id as 'v_serviceStoreId',\n\tv.jsdy as 'v_serviceGuideId',\n\tb.id as 'c_id',\n\tv.id as 'v_id',\n\tv.lb_id as 'v_lbid'\nFROM\n\tipos_vip v\nLEFT JOIN ipos_customer b ON v.gk_id = b.id\nWHERE\n\tv.sj = ? and v.status=1";
        JSONObject vipId = QueryEngine.queryJSONObject((String)sql, (Object[])new Object[]{phone});
        if (vipId == null) {
            return ResultUtil.disposeResult((String)"8888", (String)"\u7ebf\u4e0b\u6ca1\u6709\u4f1a\u5458,\u9700\u8981\u91cd\u65b0\u5f00\u5361").toString();
        }
        this.logger.info("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f:{}", (Object)vipId);
        String v_lbid = vipId.optString("v_lbid");
        String viplbsql = "select l.lbmc as lbmc from ipos_viplb l where l.id = ?";
        JSONObject LB = QueryEngine.queryJSONObject((String)viplbsql, (Object[])new Object[]{v_lbid});
        String lbmc = LB.optString("lbmc");
        String c_id = vipId.optString("c_id");
        String v_id = vipId.optString("v_id");
        if (StringUtil.isNotNull((Object)openStoreCode)) {
            String v_serviceStoreId;
            String storeSql = "select id from com_base_kehu w where w.khdm = ?";
            JSONObject storeJson = QueryEngine.queryJSONObject((String)storeSql, (Object[])new Object[]{openStoreCode});
            if (storeJson == null) {
                return ResultUtil.disposeResult((String)"-1", (String)("\u95e8\u5e97:" + openStoreCode + "\u4e0d\u5b58\u5728")).toString();
            }
            this.logger.info("\u66f4\u65b0\u670d\u52a1\u95e8\u5e97\u4fe1\u606f:{}", (Object)storeJson);
            String c_serviceStoreId = vipId.optString("c_serviceStoreId");
            String storeId = storeJson.optString("id");
            if (!c_serviceStoreId.equals(storeId)) {
                this.logger.info("\u66f4\u65b0ipos_customer\u670d\u52a1\u95e8\u5e97\u4fe1\u606f");
                String updateCustomerStoreSql = "update ipos_customer set zd_id = ? where id = ?";
                QueryEngine.doUpdate((String)updateCustomerStoreSql, (Object[])new Object[]{storeId, c_id});
            }
            if (!(v_serviceStoreId = vipId.optString("v_serviceStoreId")).equals(storeId)) {
                this.logger.info("\u66f4\u65b0ipos_vip\u670d\u52a1\u95e8\u5e97\u4fe1\u606f");
                String updateVipStoreSql = "update ipos_vip set sszd_id = ? where id = ?";
                QueryEngine.doUpdate((String)updateVipStoreSql, (Object[])new Object[]{v_serviceStoreId, v_id});
            }
        }
        if (StringUtil.isNotNull((Object)openGuideCode)) {
            String v_serviceGuideId;
            String guideSql = "select id from com_base_kehu w where w.khdm = ?";
            JSONObject guideJson = QueryEngine.queryJSONObject((String)guideSql, (Object[])new Object[]{openGuideCode});
            if (guideJson == null) {
                return ResultUtil.disposeResult((String)"-1", (String)("\u5bfc\u8d2d:" + openGuideCode + "\u4e0d\u5b58\u5728")).toString();
            }
            this.logger.info("\u66f4\u65b0\u670d\u52a1\u5bfc\u8d2d\u4fe1\u606f:{}", (Object)guideJson);
            String guideId = guideJson.optString("id");
            String c_serviceGuideId = vipId.optString("c_serviceGuideId");
            if (!guideId.equals(c_serviceGuideId)) {
                this.logger.info("\u66f4\u65b0ipos_customer\u670d\u52a1\u5bfc\u8d2d\u4fe1\u606f");
                String updateCustomerGuideSql = "update ipos_customer set dy_id = ? where id = ?";
                QueryEngine.doUpdate((String)updateCustomerGuideSql, (Object[])new Object[]{guideId, c_id});
            }
            if (!guideId.equals(v_serviceGuideId = vipId.optString("v_serviceGuideId"))) {
                this.logger.info("\u66f4\u65b0ipos_vip\u670d\u52a1\u5bfc\u8d2d\u4fe1\u606f");
                String updateVipGuideSql = "update ipos_vip set jsdy = ? where id = ?";
                QueryEngine.doUpdate((String)updateVipGuideSql, (Object[])new Object[]{guideId, c_id});
            }
        }
        String vipSql = "SELECT\n\tc.lbdm AS 'levelCode',\n\tv.vpdm AS 'offlineCardNo',\n\tv.dqjf AS 'countIntegral',\n\tv.yxrq AS 'effectiveTime',\n\tv.vpmc AS 'name',\n\tb.xb AS 'gender',\n\tv.sr1 AS 'birthday',\n\te1.region_name AS 'province',\n\te2.region_name AS 'city',\n\te3.region_name AS 'county',\n\tb.dz AS 'address',\n\tk1.khdm AS 'openStoreCode',\n\tk1.id AS 'openStoreId',\n\tk1.khmc AS 'openStoreName',\n\tk2.khdm AS 'serviceStoreCode',\n\td1.dydm AS 'openGuideCode',\n\td1.id AS 'openGuideId',\n\td2.dydm AS 'serviceGuideCode',\n\tv.Id AS 'erpId'\nFROM\n\tipos_vip v\nLEFT JOIN ipos_viplb c ON v.lb_id = c.id\nLEFT JOIN ipos_customer b ON v.gk_id = b.id\nLEFT JOIN com_base_kehu k1 ON b.dj_zd = k1.id\nLEFT JOIN com_base_kehu k2 ON b.zd_id = k2.id\nLEFT JOIN ipos_dianyuan d1 ON b.jddy_id = d1.id\nLEFT JOIN ipos_dianyuan d2 ON b.dy_id = d2.id\nLEFT JOIN region e1 ON e1.region_id = k2.PROVINCE_ID\nLEFT JOIN region e2 ON e2.region_id = k2.CITY_ID\nLEFT JOIN region e3 ON e3.region_id = k2.district_id\nWHERE\n\tv.sj = ?";
        JSONObject vipInfo = QueryEngine.queryJSONObject((String)vipSql, (Object[])new Object[]{phone});
        this.logger.info("\u67e5\u8be2\u6240\u6709\u4f1a\u5458\u4fe1\u606f:{}", (Object)vipInfo);
        Date now = new Date();
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowStr = dateFormat2.format(now);
        String insertLszSql = "insert ipos_vplsz(pid,tn_id,vp_id,vpdm,vpmc,czmc,Czsj,Zddm,zd_id,Zdmc,Lastchanged,dy_id,xl_id,lb_id,Yyrq) values(?,'0',?,?,?,'\u7ed1\u5361',unix_timestamp(?),?,?,?,now(),?,'1',?,unix_timestamp(?))";
        try {
            long l = QueryEngine.doSave((String)insertLszSql, (Object[])new Object[]{v_id, v_id, vipInfo.optString("offlinecardno"), vipInfo.optString("name"), nowStr, vipInfo.optString("openstorecode"), vipInfo.optString("openstoreid"), vipInfo.optString("openstorename"), vipInfo.optString("openguideid"), v_lbid, nowStr});
        }
        catch (Exception e) {
            this.logger.info("\u8001\u4f1a\u5458\u7ed1\u5361\u65b0\u63d2\u8bb0\u5f55\u51fa\u9519");
            e.printStackTrace();
            throw new ApiException("\u8001\u4f1a\u5458\u7ed1\u5361\u65b0\u63d2\u8bb0\u5f55\u5931\u8d25\uff01");
        }
        JSONObject resultJson = new JSONObject();
        resultJson.put("levelCode", (Object)vipInfo.optString("levelcode"));
        resultJson.put("offlineCardNo", (Object)vipInfo.optString("offlinecardno"));
        resultJson.put("countIntegral", (Object)vipInfo.optString("countintegral"));
        resultJson.put("effectiveTime", (Object)DateUtils.stampToYMD(vipInfo.optString("effectivetime", "0")));
        resultJson.put("name", (Object)vipInfo.optString("name"));
        resultJson.put("gender", (Object)vipInfo.optString("gender"));
        resultJson.put("birthday", (Object)DateUtils.stampToYMD(vipInfo.optString("birthday", "0")));
        resultJson.put("province", (Object)vipInfo.optString("province"));
        resultJson.put("city", (Object)vipInfo.optString("city"));
        resultJson.put("county", (Object)vipInfo.optString("county"));
        resultJson.put("address", (Object)vipInfo.optString("address"));
        resultJson.put("openStoreCode", (Object)vipInfo.optString("openstorecode"));
        resultJson.put("openGuideCode", (Object)vipInfo.optString("openguidecode"));
        resultJson.put("erpId", (Object)vipInfo.optString("erpid"));
        return ResultUtil.disposeResult((String)"0", (String)"\u7ed1\u5361\u6210\u529f", (JSONObject)resultJson).toString();
    }

    public static void main(String[] args) {
        BigDecimal bigDecimal = new BigDecimal("12300.0");
        System.out.println(bigDecimal);
    }
}

