/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.excel;

import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportUtil.class);

    public static void main(String[] args) {
        new ExcelImportUtil();
        ResponseData<Object> r = ExcelImportUtil.check("https://vipupload.pvgairport.com/doc/20250324/SZECt9/%E7%99%BE%E7%9B%9B%E6%8E%A5%E5%8F%A3%E5%AF%B9%E6%8E%A5.csv");
        log.info("{}", (Object)JacksonUtil.bean2Json(r));
    }

    public List<List<String>> parseExcel(String filePath) {
        log.info("ExcelImportUtil.parseExcel: {}", (Object)filePath);
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        URI uri = URI.create(filePath);
        try {
            URL url = uri.toURL();
            try (InputStream inputStream = url.openConnection().getInputStream();
                 Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
                Sheet sheet = workbook.getSheetAt(0);
                log.info("\u6570\u636e\u603b\u91cf:{}", (Object)sheet.getLastRowNum());
                for (int rowIndex = 1; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) {
                        log.info("\u7a7a\u884c\u4e0d\u5904\u7406");
                        continue;
                    }
                    List<String> rowData = ExcelImportUtil.getStrings(row);
                    data.add(rowData);
                }
                log.info("\u6709\u6548\u6570\u636e\u603b\u91cf:{}", (Object)data.size());
            }
        }
        catch (MalformedURLException e) {
            log.error("ExcelImportUtil.error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
        catch (IOException e) {
            log.error("ExcelImportUtil.error2: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
        return data;
    }

    private static boolean isXlsx(InputStream inputStream) {
        try {
            byte[] header = new byte[4];
            int read = inputStream.read(header);
            return read == 4 && header[0] == 80 && header[1] == 75;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getTitle(String filePath) {
        log.info("ExcelImportUtil.parseExcel1: {}", (Object)filePath);
        ArrayList<String> data = new ArrayList<String>();
        URI uri = URI.create(filePath);
        try {
            URL url = uri.toURL();
            try (InputStream inputStream = url.openConnection().getInputStream();
                 Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
                Row row;
                block35: {
                    Sheet sheet = workbook.getSheetAt(0);
                    int rowIndex = 0;
                    while (rowIndex <= 0) {
                        row = sheet.getRow(rowIndex);
                        if (row == null) {
                            log.info("\u7a7a\u884c\u4e0d\u5904\u74061");
                            ++rowIndex;
                            continue;
                        }
                        break block35;
                    }
                    return data;
                }
                List<String> list = ExcelImportUtil.getStrings(row);
                return list;
            }
        }
        catch (MalformedURLException e) {
            log.error("ExcelImportUtil.error1: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
        catch (IOException e) {
            log.error("ExcelImportUtil.error11: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
    }

    @NotNull
    private static List<String> getStrings(Row row) {
        ArrayList<String> rowData = new ArrayList<String>();
        for (Cell cell : row) {
            switch (cell.getCellType()) {
                case STRING: {
                    rowData.add(cell.getStringCellValue());
                    break;
                }
                case NUMERIC: {
                    rowData.add(NumberToTextConverter.toText((double)cell.getNumericCellValue()));
                    break;
                }
                case BOOLEAN: {
                    rowData.add(String.valueOf(cell.getBooleanCellValue()));
                    break;
                }
                case FORMULA: {
                    rowData.add(cell.getCellFormula());
                }
            }
        }
        if (rowData.isEmpty()) {
            rowData.add("");
        }
        return rowData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseData<Object> check(String filePath) {
        log.info("ExcelImportUtil.check: {}", (Object)filePath);
        URI uri = URI.create(filePath);
        try {
            URL url = uri.toURL();
            InputStream inputStream = url.openConnection().getInputStream();
            if (!ExcelImportUtil.isXlsx(inputStream)) {
                inputStream.close();
                log.error("ExcelImportUtil.type.check.false");
                return new ResponseData<Object>(-1, "\u8bf7\u4e0a\u4f20xlsx\u683c\u5f0f\u7684\u6587\u4ef6");
            }
            inputStream.close();
            try (InputStream newInputStream = url.openConnection().getInputStream();){
                Workbook workbook = WorkbookFactory.create((InputStream)newInputStream);
                Sheet sheet = workbook.getSheetAt(0);
                int rowIndex = 1;
                while (rowIndex <= sheet.getLastRowNum()) {
                    Row row = sheet.getRow(rowIndex);
                    List<String> list = ExcelImportUtil.getStrings(row);
                    for (String item : list) {
                        if (!"<?php".equals(item)) continue;
                        log.error("ExcelImportUtil.type.check.php:{}", (Object)item);
                        ResponseData<Object> responseData = new ResponseData<Object>(-1, "\u6587\u4ef6\u5305\u542b\u975e\u6cd5\u5185\u5bb9");
                        return responseData;
                    }
                    ++rowIndex;
                }
                return new ResponseData<Object>();
            }
        }
        catch (MalformedURLException e) {
            log.error("ExcelImportUtil.check.MalformedURLException: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData<Object>(-1, "\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
        catch (IOException e) {
            log.error("ExcelImportUtil.check.IOException: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData<Object>(-1, "\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
    }
}

