package com.bizvane.utils.enumutils;


public enum IntegralMallWholeStoreTypeEnum {
    WHOLE_STORE_TYPE_NOT_CONFIG(0, "无需配置"),
    WHOLE_STORE_TYPE_FIXED(1, "统一设置"),
    WHOLE_STORE_TYPE_SELF_SETTING(2, "独立设置");

    private final Integer type;
    private final String typeDes;
    IntegralMallWholeStoreTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallWholeStoreTypeEnum deliveryEnum : IntegralMallWholeStoreTypeEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
