package com.bizvane.utils.sql;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


@Data
public class TableDictVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("表名称")
    private String tableName;

    @ApiModelProperty("表别名")
    private String alias;

    @ApiModelProperty("字段名称")
    private String fieldName;

    @ApiModelProperty("字段中文名称")
    private String chnName;

    @ApiModelProperty("字段类型")
    private String fieldDataType;

    @ApiModelProperty("枚举code")
    private String enumOption;

    @ApiModelProperty("是否like查询")
    private Boolean isLike;

    private List<MatchVo> matchs;

    private List<BeforeVo> befores;

    private List<FormatVo> foramts;

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class MatchVo {

        /**
         * 运算符号
         * 用于比较两个值，包括等于(=)、不等于(!=或<>)、大于(>)、小于(<)、大于等于(>=)、小于等于(<=) in*
         * */
        private  String operator;

        /**
         * 中文名称
         * */
        private String name;
    }

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class BeforeVo {

        /*
         * 1 过去 2 未来
         * */
        private String code;

        private String name;

    }

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class FormatVo {

        private String code;

        private String name;

    }
}
