package com.bizvane.utils.excel;

import com.bizvane.utils.exception.BizException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
@Slf4j
public class ExcelImportUtil {

    public static void main(String[] args) {

        getTitle("https://testvipupload.pvgairport.com/doc/20250225/lVD6Jq/%E5%A4%96%E9%83%A8%E5%88%B8%E5%AF%BC%E5%85%A5%E6%A8%A1%E7%89%88%20%283%29.xlsx");
    }
    /**
     * 解析Excel文件，返回每一行的数据
     *
     * @param filePath Excel文件路径
     * @return List<List<String>> 每一行的数据集合
     * @throws IOException
     */
    public List<List<String>> parseExcel(String filePath) {
        log.info("ExcelImportUtil.parseExcel: {}", filePath);
        List<List<String>> data = new ArrayList<>();
        URI uri = URI.create(filePath);
        URL url;
        try {
            url = uri.toURL();
            try (InputStream inputStream = url.openConnection().getInputStream();
                 Workbook workbook = WorkbookFactory.create(inputStream)) {

                Sheet sheet = workbook.getSheetAt(0);
                log.info("数据总量:{}", sheet.getLastRowNum());
                for (int rowIndex = 1; rowIndex <= sheet.getLastRowNum(); rowIndex++) {
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) {
                        log.info("空行不处理");
                        continue; // Skip empty rows
                    }
                    // Retrieve row data
                    List<String> rowData = getStrings(row);
                    data.add(rowData);
                }
                log.info("有效数据总量:{}", data.size());
            }
        } catch (MalformedURLException e) {
            log.error("ExcelImportUtil.error: {}", ExceptionUtils.getStackTrace(e));
            throw new BizException("处理导入文件异常");
        } catch (IOException e) {
            log.error("ExcelImportUtil.error2: {}", ExceptionUtils.getStackTrace(e));
            throw new BizException("处理导入文件异常");
        }

        return data;
    }

    public static List<String> getTitle(String filePath) {
        log.info("ExcelImportUtil.parseExcel1: {}", filePath);
        List<String> data = new ArrayList<>();
        URI uri = URI.create(filePath);
        URL url;
        try {
            url = uri.toURL();
            try (InputStream inputStream = url.openConnection().getInputStream();
                 Workbook workbook = WorkbookFactory.create(inputStream)) {

                Sheet sheet = workbook.getSheetAt(0);

                for (int rowIndex = 0; rowIndex <= 0; rowIndex++) {
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) {
                        log.info("空行不处理1");
                        continue; // Skip empty rows
                    }
                    // Retrieve row data
                    return getStrings(row);
                }
            }
        } catch (MalformedURLException e) {
            log.error("ExcelImportUtil.error1: {}", ExceptionUtils.getStackTrace(e));
            throw new BizException("处理导入文件异常");
        } catch (IOException e) {
            log.error("ExcelImportUtil.error11: {}", ExceptionUtils.getStackTrace(e));
            throw new BizException("处理导入文件异常");
        }

        return data;
    }

    @NotNull
    private static List<String> getStrings(Row row) {
        List<String> rowData = new ArrayList<>();
        for (Cell cell : row) {
            switch (cell.getCellType()) {
                case STRING:
                    rowData.add(cell.getStringCellValue());
                    break;
                case NUMERIC:
                    rowData.add(NumberToTextConverter.toText(cell.getNumericCellValue()));
                    break;
                case BOOLEAN:
                    rowData.add(String.valueOf(cell.getBooleanCellValue()));
                    break;
                case FORMULA:
                    rowData.add(cell.getCellFormula());
                    break;
                default:
                    rowData.add("");
            }
        }
        return rowData;
    }
}
