package com.bizvane.utils.enumutils;

import lombok.Getter;

@Getter
public enum IntegralChangeWayEnum {
    EXPENSE(1,"支出"),
    INCOME(2, "收入"),
    EXPIRED(3, "过期");

    private Integer type;

    private String typeDes;

    IntegralChangeWayEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }

    public static String getDes(Integer type) {
        for (IntegralChangeWayEnum integralChangeWay : IntegralChangeWayEnum.values()) {
            if (integralChangeWay.getType().equals(type)) {
                return integralChangeWay.getTypeDes();
            }
        }
        return "未知";
    }
}