package com.bizvane.utils.enumutils;

import lombok.Getter;

import java.util.Objects;

/**
 * 员工来源枚举
 * 1-会员运营平台、2-总线、3-开放平台
 */

@Getter
public enum StaffSourceEnum {

    MEMBERS_ADMIN(1, "会员运营平台"),
    MEMBERS_HR(2, "总线HR系统"),
    MEMBERS_OPENAPI(3, "开放平台"),
    ;
    private final Integer code;
    private final String value;

    StaffSourceEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public static StaffSourceEnum getValueByCode(Integer code) {
        for (StaffSourceEnum value : StaffSourceEnum.values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }
}
