/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.excel;

import com.bizvane.utils.exception.BizException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportUtil.class);

    public static void main(String[] args) {
        new ExcelImportUtil().parseExcel("https://airport-uat-1329502467.cos.ap-shanghai.myqcloud.com/doc/20241210/FuG96i%E7%A7%AF%E5%88%86%E6%89%B9%E9%87%8F%E6%9B%B4%E6%96%B0%E6%A8%A1%E6%9D%BF%20%281%29.xlsx");
    }

    public List<List<String>> parseExcel(String filePath) {
        log.info("ExcelImportUtil.parseExcel: {}", (Object)filePath);
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        URI uri = URI.create(filePath);
        try {
            URL url = uri.toURL();
            try (InputStream inputStream = url.openConnection().getInputStream();
                 Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
                Sheet sheet = workbook.getSheetAt(0);
                for (int rowIndex = 1; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) {
                        log.info("\u7a7a\u884c\u4e0d\u5904\u7406");
                        continue;
                    }
                    List<String> rowData = ExcelImportUtil.getStrings(row);
                    data.add(rowData);
                }
            }
        }
        catch (MalformedURLException e) {
            log.error("ExcelImportUtil.error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
        catch (IOException e) {
            log.error("ExcelImportUtil.error2: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
        return data;
    }

    @NotNull
    private static List<String> getStrings(Row row) {
        ArrayList<String> rowData = new ArrayList<String>();
        block6: for (Cell cell : row) {
            switch (cell.getCellType()) {
                case STRING: {
                    rowData.add(cell.getStringCellValue());
                    continue block6;
                }
                case NUMERIC: {
                    rowData.add(NumberToTextConverter.toText((double)cell.getNumericCellValue()));
                    continue block6;
                }
                case BOOLEAN: {
                    rowData.add(String.valueOf(cell.getBooleanCellValue()));
                    continue block6;
                }
                case FORMULA: {
                    rowData.add(cell.getCellFormula());
                    continue block6;
                }
            }
            rowData.add("");
        }
        return rowData;
    }
}

