package com.bizvane.utils.responseinfo;

import com.bizvane.utils.enumutils.SysResponseEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * @author Micro
 * @Title: 返回信息基类
 * @Package ${package_name}
 * @Description: ${todo}
 * @date 2018/6/19 19:12
 */
@ApiModel(value = "请求输出参数基类")
public class ResponseData<T> implements Serializable {

    @ApiModelProperty(value = "响应编码, 0：成功, 其他见code码说明文档", example = "0")
    private int code = SysResponseEnum.SUCCESS.getCode();

    @ApiModelProperty(value = "提示消息", example = "请求成功")
    private String message = SysResponseEnum.SUCCESS.getMessage();

    @ApiModelProperty(value = "返回数据对象")
    private T data;

    public ResponseData(T data) {
        this.data = data;
    }

    public ResponseData() {
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public ResponseData(int code, String message, T data) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public ResponseData(int code, T data) {
        this.code = code;
        this.data = data;
    }

    public ResponseData(String message, T data) {
        this.data = data;
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }


    public ResponseData(int code, String message) {
        this.code = code;
        this.message = message;
    }
}
