/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"spring.redis.host"})
@Component
public class DistributedLock {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    public boolean acquireLock(String lockKey, long expireTime) {
        return this.setIfAbsent(lockKey, expireTime, 10, 100L);
    }

    public void releaseLock(String lockKey) {
        this.redisTemplate.delete((Object)lockKey);
    }

    private boolean setIfAbsent(String lockKey, long expireTime, int count, long sleepTime) {
        ValueOperations ops = this.redisTemplate.opsForValue();
        for (int i = 0; i < count; ++i) {
            if (Boolean.TRUE.equals(ops.setIfAbsent((Object)lockKey, (Object)"1", expireTime, TimeUnit.MILLISECONDS))) {
                return true;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            sleepTime += 100L;
        }
        return false;
    }
}

