package com.bizvane.utils.enumutils;

import lombok.Getter;


@Getter
public enum CouponpPeferentialTypeEnum {
    // 优惠类型（1现金,2折扣,3兑换）
    CASH(1, "现金"),
    DISCOUNT(2, "折扣"),
    EXCHANGE(3, "兑换");

    private Integer type;

    private String typeDes;

    CouponpPeferentialTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getTypeDes(Integer type) {
        for (CouponpPeferentialTypeEnum couponpPeferentialTypeEnum : CouponpPeferentialTypeEnum.values()) {
            if (couponpPeferentialTypeEnum.getType().equals(type)) {
                return couponpPeferentialTypeEnum.getTypeDes();
            }
        }
        return null;
    }
}