package com.bizvane.utils.enumutils;

import lombok.Getter;

@Getter
public enum CouponSendTypeEnum {
    // 10-会员权益领取, 20-会员注册活动, 30-会员升级活动, 40-会员签到活动, 50-会员生日活动, 60-会员消费活动, 70-会员领券活动, 80-积分夺宝活动, 90-幸运大转盘, 100-邀请入会任务, 110-完善资料任务, 120-会员乘机任务, 130-调查问卷任务, 140-批量发券任务, 150-优惠券转赠获取, 160-积分商城兑换, 170-外部系统发放
    NORMAL(10, "会员权益领取"),
    REGISTER(20, "会员注册活动"),
    UPGRADE(30, "会员升级活动"),
    SIGN(40, "会员签到活动"),
    BIRTHDAY(50, "会员生日活动"),
    REVIEW(55, "评价有礼"),
    CONSUME(60, "会员消费活动"),
    COUPON(70, "会员领券活动"),
    LUCKY(80, "幸运大转盘"),
    INVITE(90, "邀请入会任务"),
    PERFECT(100, "完善资料任务"),
    FLY(120, "会员乘机任务"),
    QUESTIONNAIRE(130, "调查问卷任务"),
    BATCH(140, "批量发券任务"),
    TRANSFER(150, "优惠券转赠获取"),
    SHOP(160, "积分商城兑换"),
    EXTERNAL(170, "外部系统发放");

    private Integer type;

    private String typeDes;

    CouponSendTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }

    public static CouponValidTypeEnum getType(Integer type) {
        for (CouponValidTypeEnum validType : CouponValidTypeEnum.values()) {
            if (validType.getType().equals(type)) {
                return validType;
            }
        }
        return null;
    }

    public static String getDes(Integer type) {
        for (CouponSendTypeEnum sendTypeEnum : CouponSendTypeEnum.values()) {
            if (sendTypeEnum.getType().equals(type)) {
                return sendTypeEnum.getTypeDes();
            }
        }
        return "未知";
    }
}


