package com.bizvane.utils.enumutils;

import lombok.Getter;


@Getter
public enum OrderTypeEnum {
    // 订单类型：1-商户订单，2-停车订单，3-酒店订单，4-贵宾服务，5-机场管家;
    MERCHANT_ORDER(1, "商户订单"),
    PARKING_ORDER(2, "停车订单"),
    HOTEL_ORDER(3, "酒店订单"),
    GUEST_SERVICE(4, "贵宾服务"),
    AIRPORT_GUARD(5, "机场管家");

    private final Integer type;

    private final String typeDes;

    OrderTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
}