/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.code;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(QRCodeGenerator.class);
    private static final int QR_CODE_WIDTH = 300;
    private static final int QR_CODE_HEIGHT = 300;
    private static final int BARCODE_WIDTH = 300;
    private static final int BARCODE_HEIGHT = 100;

    public static void main(String[] args) {
        String barcodeText = "123456789";
        String filePath = "Barcode.png";
        int width = 300;
        int height = 100;
        try {
            Code128Writer barcodeWriter = new Code128Writer();
            HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
            hints.put(EncodeHintType.MARGIN, 0);
            BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.CODE_128, width, height, hints);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            BufferedImage croppedImage = QRCodeGenerator.cropImage(bufferedImage);
            ImageIO.write((RenderedImage)croppedImage, "png", new File(filePath));
            System.out.println("\u6761\u5f62\u7801\u5df2\u751f\u6210\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a: " + filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] generateQRCode(String data) {
        return QRCodeGenerator.generateBarcode(data, BarcodeFormat.QR_CODE, 300, 300);
    }

    public static byte[] generateBarCode(String data) {
        return QRCodeGenerator.generateBarcode(data, BarcodeFormat.CODE_128, 300, 100);
    }

    private static byte[] generateBarcode(String data, BarcodeFormat format, int width, int height) {
        byte[] byteArray = null;
        try {
            HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
            hints.put(EncodeHintType.MARGIN, 0);
            BufferedImage bufferedImage = null;
            if (format == BarcodeFormat.QR_CODE) {
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                BitMatrix bitMatrix = qrCodeWriter.encode(data, format, width, height, hints);
                bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            } else {
                Code128Writer barcodeWriter = new Code128Writer();
                BitMatrix bitMatrix = barcodeWriter.encode(data, format, width, height, hints);
                bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                bufferedImage = QRCodeGenerator.cropImage(bufferedImage);
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                byteArray = byteArrayOutputStream.toByteArray();
                log.info("\u751f\u6210\u7684\u5b57\u8282\u6570\u7ec4\u5927\u5c0f1: {}", (Object)byteArray.length);
            }
        }
        catch (WriterException e) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801/\u6761\u5f62\u7801\u5931\u8d251: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801/\u6761\u5f62\u7801 IO\u5f02\u5e381: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return byteArray;
    }

    private static BufferedImage cropImage(BufferedImage image) {
        int x;
        boolean isEmptyRow;
        int y;
        int y2;
        boolean isEmptyColumn;
        int x2;
        int width = image.getWidth();
        int height = image.getHeight();
        int left = 0;
        int right = width;
        int top = 0;
        int bottom = height;
        for (x2 = 0; x2 < width; ++x2) {
            isEmptyColumn = true;
            for (y2 = 0; y2 < height; ++y2) {
                if (image.getRGB(x2, y2) == -1) continue;
                isEmptyColumn = false;
                break;
            }
            if (isEmptyColumn) continue;
            left = x2;
            break;
        }
        for (x2 = width - 1; x2 >= 0; --x2) {
            isEmptyColumn = true;
            for (y2 = 0; y2 < height; ++y2) {
                if (image.getRGB(x2, y2) == -1) continue;
                isEmptyColumn = false;
                break;
            }
            if (isEmptyColumn) continue;
            right = x2 + 1;
            break;
        }
        for (y = 0; y < height; ++y) {
            isEmptyRow = true;
            for (x = left; x < right; ++x) {
                if (image.getRGB(x, y) == -1) continue;
                isEmptyRow = false;
                break;
            }
            if (isEmptyRow) continue;
            top = y;
            break;
        }
        for (y = height - 1; y >= 0; --y) {
            isEmptyRow = true;
            for (x = left; x < right; ++x) {
                if (image.getRGB(x, y) == -1) continue;
                isEmptyRow = false;
                break;
            }
            if (isEmptyRow) continue;
            bottom = y + 1;
            break;
        }
        return image.getSubimage(left, top, right - left, bottom - top);
    }
}

