package com.bizvane.utils.redisutils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

@ConditionalOnProperty(name = "spring.redis.host")
@Component
public class DistributedLock {

    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    public boolean acquireLock(String lockKey, long expireTime) {
        return setIfAbsent(lockKey, expireTime, 10, 100);
    }

    public void releaseLock(String lockKey) {
        redisTemplate.delete(lockKey);
    }

    private boolean setIfAbsent(String lockKey, long expireTime, int count, long sleepTime) {
        ValueOperations<Object, Object> ops = redisTemplate.opsForValue();
        for (int i = 0; i < count; i++) {
            if (Boolean.TRUE.equals(ops.setIfAbsent(lockKey, "1", expireTime, TimeUnit.MILLISECONDS))) {
                return true;
            }
            try {
                Thread.sleep(sleepTime);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            sleepTime += 100; // 增加 sleep 时间
        }
        return false;
    }
}
