package com.bizvane.utils.enumutils;

import lombok.Getter;

/**
 * 会员卡状态
 */
@Getter
public enum OrderStatusEnum {
    // 订单状态：1-待付款, 2-待发货, 3-已发货, 4-已签收, 5-交易成功, 6-退款中, 7-退款成功, 8-交易关闭
    WAIT_PAY(1, "待付款"),
    WAIT_DELIVERY(2, "待发货"),
    DELIVERY(3, "已发货"),
    SIGN(4, "已签收"),
    SUCCESS(5, "交易成功"),
    REFUNDING(6, "退款中"),
    REFUND_SUCCESS(7, "退款成功"),
    CLOSE(8, "交易关闭");

    private final Integer type;

    private final String typeDes;

    OrderStatusEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
}