/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.code;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(QRCodeGenerator.class);
    private static final int QR_CODE_WIDTH = 300;
    private static final int QR_CODE_HEIGHT = 300;
    private static final int BARCODE_WIDTH = 300;
    private static final int BARCODE_HEIGHT = 150;

    public static void main(String[] args) {
        QRCodeGenerator.generateBarCode("123");
        QRCodeGenerator.generateQRCode("123");
    }

    public static byte[] generateQRCode(String data) {
        return QRCodeGenerator.generateBarcode(data, BarcodeFormat.QR_CODE, 300, 300);
    }

    public static byte[] generateBarCode(String data) {
        return QRCodeGenerator.generateBarcode(data, BarcodeFormat.CODE_128, 300, 150);
    }

    private static byte[] generateBarcode(String data, BarcodeFormat format, int width, int height) {
        byte[] byteArray = null;
        try {
            BitMatrix bitMatrix;
            if (format == BarcodeFormat.QR_CODE) {
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                bitMatrix = qrCodeWriter.encode(data, format, width, height);
            } else {
                Code128Writer barcodeWriter = new Code128Writer();
                bitMatrix = barcodeWriter.encode(data, format, width, height);
            }
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                byteArray = byteArrayOutputStream.toByteArray();
                log.info("\u751f\u6210\u7684\u5b57\u8282\u6570\u7ec4\u5927\u5c0f: {}", (Object)byteArray.length);
            }
        }
        catch (WriterException e) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801/\u6761\u5f62\u7801\u5931\u8d25: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801/\u6761\u5f62\u7801 IO\u5f02\u5e38: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return byteArray;
    }
}

