package com.bizvane.utils.code;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
@Slf4j
public class QRCodeGenerator {

    private static final int QR_CODE_WIDTH = 300;
    private static final int QR_CODE_HEIGHT = 300;
    private static final int BARCODE_WIDTH = 300;
    private static final int BARCODE_HEIGHT = 150;

    public static void main(String[] args) {
        generateBarCode("123");

        generateQRCode("123");
    }

    public static byte[] generateQRCode(String data) {
        return generateBarcode(data, BarcodeFormat.QR_CODE, QR_CODE_WIDTH, QR_CODE_HEIGHT);
    }

    public static byte[] generateBarCode(String data) {
        return generateBarcode(data, BarcodeFormat.CODE_128, BARCODE_WIDTH, BARCODE_HEIGHT);
    }

    private static byte[] generateBarcode(String data, BarcodeFormat format, int width, int height) {
        byte[] byteArray = null;
        try {
            BitMatrix bitMatrix;
            if (format == BarcodeFormat.QR_CODE) {
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                bitMatrix = qrCodeWriter.encode(data, format, width, height);
            } else {
                Code128Writer barcodeWriter = new Code128Writer();
                bitMatrix = barcodeWriter.encode(data, format, width, height);
            }

            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);

            // 将BufferedImage写入ByteArrayOutputStream
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream()) {
                ImageIO.write(bufferedImage, "png", byteArrayOutputStream);
                byteArray = byteArrayOutputStream.toByteArray();
                log.info("生成的字节数组大小: {}", byteArray.length);
            }  // 自动关闭输出流
        } catch (WriterException e) {
            log.error("生成二维码/条形码失败: {}", ExceptionUtils.getStackTrace(e));
        } catch (IOException e) {
            log.error("生成二维码/条形码 IO异常: {}", ExceptionUtils.getStackTrace(e));
        }
        return byteArray;
    }
}
