/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.sql;

import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.commonutils.SqlCheckUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.sql.GroupConditionDateVo;
import com.bizvane.utils.sql.GroupConditionSubVo;
import com.bizvane.utils.sql.GroupConditionValueVo;
import com.bizvane.utils.sql.GroupConditionVo;
import com.bizvane.utils.sql.OperatorEnum;
import com.bizvane.utils.sql.SqlGetBirthdaySqlParam;
import com.bizvane.utils.sql.SqlOperatorUtil;
import com.bizvane.utils.sql.TableDictVO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtil.class);
    private static final String BIRTHDAY_SQL = "select m.id, m.mbr_members_code, m.card_no, m.name, m.gender, m.phone, m.phone_encrypt, m.email, m.id_card, m.birthday, m.province, m.city, m.county, m.address, m.head_portraits, m.bar_code, m.card_status, m.status_flag, m.open_card_time, mbr_level_def_code, m.extend_ids, m.count_integral, m.remark, m.create_user_code, m.create_user_name, m.create_date, m.modified_user_code, m.modified_user_name, m.modified_date ";

    public static void main(String[] args) {
        String s = "{\"isAnd\":1,\"conditions\":[{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"mbr_level_def_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"24\"],\"value\":\"24\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]}]}";
        TemplateUtil.makeupSql(Objects.requireNonNull(JacksonUtil.json2Obj(s, GroupConditionVo.class)));
    }

    public static String getBirthdaySql(SqlGetBirthdaySqlParam param) {
        String birthdayMDStart = param.getBirthdayMDStart();
        String birthdayMDEnd = param.getBirthdayMDEnd();
        String openCardTimeStart = param.getOpenCardTimeStart();
        String openCardTimeEnd = param.getOpenCardTimeEnd();
        List<String> mbrLevelDefCodeList = param.getMbrLevelDefCodeList();
        StringBuilder builder = new StringBuilder();
        builder.append(BIRTHDAY_SQL);
        builder.append(" from t_mbr_members m left join t_mkt_activity_send_record r on m.mbr_members_code = r.mbr_members_code and r.activity_type = 7 ");
        builder.append("and r.create_date >= '").append(DateUtils.formatLocalDateTime(DateUtils.getStartOfYear())).append("'");
        builder.append(" where r.mbr_members_code is null ");
        builder.append(" and m.birthday_md >= '").append(birthdayMDStart).append("'");
        builder.append(" and m.birthday_md <= '").append(birthdayMDEnd).append("'");
        if (StringUtils.isNotBlank((CharSequence)openCardTimeStart)) {
            builder.append(" and m.open_card_time >= '").append(openCardTimeStart).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)openCardTimeEnd)) {
            builder.append(" and m.open_card_time <= '").append(openCardTimeEnd).append("'");
        }
        if (CollectionUtils.isNotEmpty(mbrLevelDefCodeList)) {
            builder.append(" and m.mbr_level_def_code in ('").append(StringUtils.join(mbrLevelDefCodeList, (String)"','")).append("')");
        }
        return builder.toString();
    }

    public static String makeupSql(GroupConditionVo conditon) {
        TemplateUtil.validConditions(conditon);
        String sql = TemplateUtil.deal(conditon);
        if (!SqlCheckUtil.sqlInjection(sql)) {
            throw new RuntimeException("\u5b58\u5728SQL\u6ce8\u5165");
        }
        log.info("group sql:{}", (Object)sql);
        return sql;
    }

    private static String deal(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        builder.append(TemplateUtil.makeupSelect());
        builder.append(" from ");
        builder.append(TemplateUtil.makeupFrom(conditon));
        builder.append(" where m.valid = 1 and ");
        if (StringUtils.isNotBlank((CharSequence)conditon.getMbrMembersCode())) {
            builder.append(" m.mbr_members_code = '").append(conditon.getMbrMembersCode()).append("' and ");
        }
        builder.append(TemplateUtil.makeupCondition(conditon));
        String orderBy = TemplateUtil.makeupOrderBy();
        builder.append(orderBy);
        return builder.toString();
    }

    private static String makeupFrom(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        ArrayList<GroupConditionValueVo> tableList = new ArrayList<GroupConditionValueVo>(conditon.getConditions().stream().flatMap(scv -> scv.getSubs().stream().filter(v -> !v.getTableName().equals("t_mbr_members"))).collect(Collectors.toMap(GroupConditionValueVo::getTableName, v -> v, (existing, replacement) -> existing)).values());
        conditon.getConditions().forEach(scv -> scv.getSubs().forEach(v -> v.setFieldName(v.getAlias() + "." + v.getFieldName())));
        builder.append(" t_mbr_members m ");
        for (GroupConditionValueVo valueVo : tableList) {
            if ("t_basic_airport".equals(valueVo.getTableName())) {
                builder.append(" join t_basic_airport airport on airport.airport_code=m.airport_code and airport.valid=1 ");
                continue;
            }
            if ("t_mbr_member_label".equals(valueVo.getTableName())) {
                builder.append(" join t_mbr_member_label label on label.mbr_members_code=m.mbr_members_code and label.valid=1  join t_mbr_label_def labeld on label.mbr_label_def_code = labeld.mbr_label_def_code and labeld.valid=1 ");
                continue;
            }
            if ("t_mbr_level_def".equals(valueVo.getTableName())) {
                builder.append(" join t_mbr_level_def leveld on leveld.mbr_level_def_code=m.mbr_level_def_code and leveld.valid=1 ");
                continue;
            }
            builder.append(" join ");
            builder.append(valueVo.getTableName()).append(" ").append(valueVo.getAlias());
            builder.append(" on ").append(valueVo.getAlias()).append(".mbr_members_code=m.mbr_members_code ").append(" and ").append(valueVo.getAlias()).append(".valid = 1");
        }
        return builder.toString();
    }

    private static String makeupSelect() {
        return " DISTINCT m.id AS id, m.mbr_members_code AS mbrMembersCode, m.card_no AS cardNo, m.name AS name, m.gender AS gender, m.phone AS phone, m.phone_encrypt AS phoneEncrypt, m.email AS email, m.id_card AS idCard, m.birthday AS birthday, m.province AS province, m.city AS city, m.county AS county, m.address AS address, m.head_portraits AS headPortraits, m.bar_code AS barCode, m.card_status AS cardStatus, m.status_flag AS statusFlag, m.open_card_time AS openCardTime, m.mbr_level_def_code AS mbrLevelDefCode, m.count_integral AS countIntegral, m.remark AS remark, m.create_user_code AS createUserCode, m.create_user_name AS createUserName, m.create_date AS createDate, m.modified_user_code AS modifiedUserCode, m.modified_user_name AS modifiedUserName, m.modified_date AS modifiedDate ";
    }

    private static String makeupCondition(GroupConditionVo conditon) {
        ArrayList<String> subs = new ArrayList<String>();
        for (GroupConditionSubVo scv : conditon.getConditions()) {
            int cnt = scv.getSubs().size();
            ArrayList<String> conditions = new ArrayList<String>();
            for (int i = 0; i < cnt; ++i) {
                conditions.add(TemplateUtil.getCondition(scv.getSubs().get(i)));
            }
            if (scv.getIsAnd() == 1) {
                subs.add(String.format("(%s)", String.join((CharSequence)" and ", conditions)));
                continue;
            }
            if (scv.getIsAnd() != 2) continue;
            subs.add(String.format("(%s)", String.join((CharSequence)" or ", conditions)));
        }
        if (conditon.getIsAnd() == 1) {
            return String.join((CharSequence)" and ", subs);
        }
        if (conditon.getIsAnd() == 2) {
            return String.join((CharSequence)" or ", subs);
        }
        return "1=1";
    }

    private static String getCondition(GroupConditionValueVo valueVo) {
        if (valueVo.getFieldDataType().equalsIgnoreCase("DATETIME")) {
            return TemplateUtil.getDateCondition(valueVo);
        }
        if (valueVo.getFieldDataType().equalsIgnoreCase("STRING")) {
            return TemplateUtil.getStringCondition(valueVo);
        }
        if (valueVo.getFieldDataType().equalsIgnoreCase("DECIMAL")) {
            return TemplateUtil.getDecimalCondition(valueVo);
        }
        if (valueVo.getFieldDataType().equalsIgnoreCase("ARRAY")) {
            return TemplateUtil.getArrayCondition(valueVo);
        }
        return "";
    }

    private static String makeupOrderBy() {
        return " Order by m.id asc";
    }

    private static String getArrayCondition(GroupConditionValueVo valueVo) {
        if (StringUtils.isNotEmpty((CharSequence)valueVo.getValue())) {
            String[] vals = valueVo.getValue().split(",");
            ArrayList<String> ors = new ArrayList<String>();
            for (String val : vals) {
                ors.add(String.format("instr(array_join(%s, '$'),'%s')>0 ", valueVo.getFieldName(), val));
            }
            return "(" + String.join((CharSequence)" or ", ors) + ")";
        }
        return "1=1";
    }

    private static String getFieldCondition(GroupConditionValueVo valueVo) {
        String[] vals;
        ArrayList<String> cons = new ArrayList<String>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        for (String val : vals = value.split(",")) {
            cons.add(fieldName + operator + val);
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join((CharSequence)" and ", cons));
        }
        return String.format("( %s )", String.join((CharSequence)" or ", cons));
    }

    private static String getStringCondition(GroupConditionValueVo valueVo) {
        ArrayList<String> cons = new ArrayList<String>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        if (StringUtils.isNotEmpty((CharSequence)valueVo.getEnumValue())) {
            value = valueVo.getEnumValue();
        }
        String[] vals = value.split(",");
        ArrayList<String> results = new ArrayList<String>();
        for (String val : vals) {
            cons.add(fieldName + operator + String.format("'%s'", val));
            if (valueVo.getFieldDataType().equals("DECIMAL")) {
                results.add(String.format("%s", val));
                continue;
            }
            results.add(String.format("'%s'", val));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s in (%s)", fieldName, String.join((CharSequence)",", results));
        }
        if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.EQUAL.getCode())) {
                return String.format("%s in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("%s not in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            return String.format("( %s )", String.join((CharSequence)" or ", cons));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join((CharSequence)" and ", cons));
        }
        return String.format("( %s )", String.join((CharSequence)" or ", cons));
    }

    private static String getDecimalCondition(GroupConditionValueVo valueVo) {
        ArrayList<String> cons = new ArrayList<String>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        ArrayList<String> results = new ArrayList<String>();
        for (String val : vals) {
            cons.add(fieldName + operator + val);
            results.add(String.format("%s", val));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s>=%s and %s<=%s", fieldName, valueVo.getIn().getVal1(), fieldName, valueVo.getIn().getVal1());
        }
        if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.EQUAL.getCode())) {
                return String.format("%s in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("%s not in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            return String.format("( %s )", String.join((CharSequence)" or ", cons));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join((CharSequence)" and ", cons));
        }
        return String.format("( %s )", String.join((CharSequence)" or ", cons));
    }

    private static String getDateCondition(GroupConditionValueVo valueVo) {
        String fieldName = valueVo.getFieldName();
        GroupConditionDateVo dateMap = valueVo.getDateMap();
        if (OperatorEnum.BETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        }
        if (OperatorEnum.NOTBETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " not between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode())) {
            if ("before".equals(dateMap.getType())) {
                return fieldName + " < '" + TemplateUtil.getDateFormat(dateMap.getUnit(), dateMap.getValue()) + "'";
            }
            if ("after".equals(dateMap.getType())) {
                return fieldName + " > '" + TemplateUtil.getDateFormat(dateMap.getUnit(), -dateMap.getValue().intValue()) + "'";
            }
        }
        return "1=1";
    }

    private static String getDateFormat(String unit, Integer value) {
        if ("day".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastDays(LocalDateTime.now(), value));
        }
        if ("hour".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastHours(LocalDateTime.now(), value));
        }
        if ("minute".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastMinutes(LocalDateTime.now(), value));
        }
        throw new RuntimeException("\u65f6\u95f4\u5355\u4f4d\u9519\u8bef");
    }

    private static void validConditions(GroupConditionVo condition) {
        if (condition != null && !CollectionUtils.isEmpty(condition.getConditions())) {
            TemplateUtil.validArgNegative(condition.getIsAnd(), "isAnd\u5c5e\u6027");
            for (GroupConditionSubVo sub : condition.getConditions()) {
                TemplateUtil.validArgNegative(sub.getIsAnd(), "isAnd\u5c5e\u6027");
                if (!CollectionUtils.isEmpty(sub.getSubs())) {
                    for (GroupConditionValueVo vv : sub.getSubs()) {
                        TemplateUtil.validArgNull(vv.getFieldName(), "\u5b57\u6bb5\u540d\u79f0");
                        TemplateUtil.validArgNull(vv.getFieldDataType(), "\u5b57\u6bb5\u7c7b\u578b");
                        if (vv.getMatch() == null) {
                            throw new RuntimeException("\u6761\u4ef6\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        TemplateUtil.validMatch(vv.getMatch());
                        if (vv.getFieldDataType().toUpperCase().equals("DECIMAL")) {
                            if (!StringUtils.isNotEmpty((CharSequence)vv.getValue())) continue;
                            String[] vals = vv.getValue().split(",");
                            TemplateUtil.validDecimal(vals, StringUtils.isNotEmpty((CharSequence)vv.getChnName()) ? vv.getChnName() : vv.getFieldName());
                            continue;
                        }
                        if (vv.getFieldDataType().toUpperCase().equals("STRING")) {
                            if (!StringUtils.isNotEmpty((CharSequence)vv.getValue()) || SqlCheckUtil.formFieldDataSqlInjection(vv.getValue())) continue;
                            throw new RuntimeException("\u4f20\u5165\u6761\u4ef6\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669");
                        }
                        if (!vv.getFieldDataType().toUpperCase().equals("DATETIME")) continue;
                        TemplateUtil.validDate(vv.getMatch(), vv.getDateMap(), vv.getDatetime());
                    }
                    continue;
                }
                throw new RuntimeException("\u5b50\u7ec4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private static void ValidInjection(String[] vals) {
        boolean existStart = false;
        boolean existEnd = false;
        for (String val : vals) {
            int cnt = TemplateUtil.countString(val.trim(), "'");
            if (cnt == 1) {
                existStart = true;
            }
            if (cnt == 1 || cnt % 2 == 0) continue;
            existEnd = true;
        }
        if (existStart && existEnd) {
            throw new RuntimeException("\u4f20\u5165\u6761\u4ef6\u5b58\u5728SQL\u6ce8\u5165");
        }
    }

    private static int countString(String str, String s) {
        int count = 0;
        int len = str.length();
        while (str.indexOf(s) != -1) {
            str = str.substring(str.indexOf(s) + 1, str.length());
            ++count;
        }
        return count;
    }

    private static void validDecimal(String[] vals, String fieldName) {
        for (String val : vals) {
            if (StringUtils.isNotEmpty((CharSequence)val)) {
                try {
                    new BigDecimal(val);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6761\u4ef6\u5b57\u6bb5:" + fieldName + "\u662f\u6570\u503c\u578b\u5b57\u6bb5,\u4e0d\u80fd\u8f93\u5165\u975e\u6570\u503c\u578b\u7684\u503c");
                }
            }
            throw new RuntimeException("\u6761\u4ef6\u5b57\u6bb5:" + fieldName + "\u672a\u8d4b\u503c");
        }
    }

    private static void validDate(TableDictVO.MatchVo match, GroupConditionDateVo vo, List<String> datetime) {
        if (match.getOperator().equals(OperatorEnum.BETWEEN.getCode()) && CollectionUtils.isEmpty(datetime)) {
            throw new RuntimeException("\u65f6\u95f4(select\u5c5e\u6027)\u672a\u8bbe\u7f6e");
        }
        if (match.getOperator().equals(OperatorEnum.NOTBETWEEN.getCode())) {
            if (CollectionUtils.isEmpty(datetime)) {
                throw new RuntimeException("\u65f6\u95f4(select\u5c5e\u6027)\u672a\u8bbe\u7f6e");
            }
        } else if (match.getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode()) && (StringUtils.isBlank((CharSequence)vo.getType()) || StringUtils.isBlank((CharSequence)vo.getUnit()) || vo.getValue() == null)) {
            throw new RuntimeException("\u65f6\u95f4(select\u5c5e\u6027)2\u672a\u8bbe\u7f6e");
        }
    }

    private static void validMatch(TableDictVO.MatchVo match) {
        TemplateUtil.validArgNull(match.getOperator(), "\u6bd4\u8f83\u65b9\u5f0f\u4ee3\u7801");
        if (!SqlOperatorUtil.contains(match.getOperator())) {
            throw new RuntimeException("\u6bd4\u8f83\u65b9\u5f0f\u4ee3\u7801" + match.getOperator() + "\u8bbe\u7f6e\u9519\u8bef");
        }
    }

    private static void validArgNull(String value, String msg) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new RuntimeException(msg + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void validArgNegative(Integer value, String msg) {
        if (value == null || value < 1) {
            throw new RuntimeException(msg + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

