package com.bizvane.utils.enumutils;

public enum PaymentType {
    COUPON(1, "优惠券"),
    BANK_CARD(2, "银行卡"),
    WECHAT(3, "微信"),
    ALIPAY(4, "支付宝"),
    CASH(5, "现金"),
    ETC(6, "ETC"),
    OTHER(7, "其他方式");

    private final int type;       // 支付类型的值
    private final String typeDesc; // 支付类型的描述

    PaymentType(int type, String typeDesc) {
        this.type = type;
        this.typeDesc = typeDesc;
    }

    public int getType() {
        return type;
    }

    public String getTypeDesc() {
        return typeDesc;
    }

    // 根据支付类型的值获取描述
    public static String getDescriptionByType(int paymentType) {
        for (PaymentType pt : values()) {
            if (pt.type == paymentType) {
                return pt.typeDesc;
            }
        }
        return "未知支付方式"; // 默认情况
    }
}
