package com.bizvane.utils.enumutils;


public enum IntegralMallDeliveryPriceEnum {
    DELIVERY_PRICE_NOT_CONFIG(0, "无需配置"),
    DELIVERY_PRICE_FREE(1, "固定运费"),
    DELIVERY_PRICE_FIXED(2, "包邮");
    private final Integer type;
    private final String typeDes;
    IntegralMallDeliveryPriceEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallDeliveryPriceEnum deliveryEnum : IntegralMallDeliveryPriceEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
