package com.bizvane.utils.enumutils;


public enum IntegralMallLogisticBusinessTypeEnum {
    MALL_LOGISTIC_ORDER(1, "积分商城订单"),
    MALL_LOGISTIC_RETURN_ORDER(2, "积分商城退单");
    private final Integer type;
    private final String typeDes;
    IntegralMallLogisticBusinessTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallLogisticBusinessTypeEnum deliveryEnum : IntegralMallLogisticBusinessTypeEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
