/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.sql;

import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.commonutils.SqlCheckUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.sql.GroupConditionDateVo;
import com.bizvane.utils.sql.GroupConditionSubVo;
import com.bizvane.utils.sql.GroupConditionValueVo;
import com.bizvane.utils.sql.GroupConditionVo;
import com.bizvane.utils.sql.OperatorEnum;
import com.bizvane.utils.sql.SqlGetBirthdaySqlParam;
import com.bizvane.utils.sql.SqlOperatorUtil;
import com.bizvane.utils.sql.TableDictVO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtil.class);
    private static final String BIRTHDAY_SQL = "select m.id, m.mbr_members_code, m.card_no, m.name, m.gender, m.phone, m.phone_encrypt, m.email, m.id_card, m.birthday, m.province, m.city, m.county, m.address, m.head_portraits, m.bar_code, m.card_status, m.status_flag, m.open_card_time, mbr_level_def_code, m.extend_ids, m.count_integral, m.remark, m.create_user_code, m.create_user_name, m.create_date, m.modified_user_code, m.modified_user_name, m.modified_date ";

    public static void main(String[] args) {
        String s = "{\"isAnd\":1,\"conditions\":[{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u90b8\u6dd1\u82f1\"],\"value\":\"\u90b8\u6dd1\u82f1\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"card_no\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"SIA20241125000001\"],\"value\":\"SIA20241125000001\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"phone_encrypt\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"17521176876\"],\"value\":\"17521176876\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"gender\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"\u5973\"},{\"code\":\"2\",\"name\":\"\u7537\"},{\"code\":\"3\",\"name\":\"\u672a\u77e5\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u7537\"],\"value\":\"\u7537\",\"enumValue\":\"2\",\"enumOption\":\"gender\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_age\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"IN\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":18,\"val2\":36},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"birthday_md\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"0301\",\"0331\"],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_level_def\",\"alias\":\"m\",\"fieldName\":\"level_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u94f6\u5361\u4f1a\u5458\"],\"value\":\"\u94f6\u5361\u4f1a\u5458\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"mbr_level_def_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"A0002\"],\"value\":\"A0002\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"province\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u5c71\u897f\u7701\"],\"value\":\"\u5c71\u897f\u7701\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"city\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u592a\u539f\u5e02\"],\"value\":\"\u592a\u539f\u5e02\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"county\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u6986\u6728\u53bf\"],\"value\":\"\u6986\u6728\u53bf\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_member_label\",\"alias\":\"labeld\",\"fieldName\":\"label_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u54c8\u54c8\"],\"value\":\"\u54c8\u54c8\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"count_integral\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"MT\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{},\"selectValues\":[],\"value\":100,\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"open_card_time\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"2024-10-01 00:00:00\",\"2024-12-31 23:59:59\"],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"card_status\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"\u6b63\u5e38\"},{\"code\":\"0\",\"name\":\"\u51bb\u7ed3\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u6b63\u5e38\"],\"value\":\"\u6b63\u5e38\",\"enumValue\":\"1\",\"enumOption\":\"card_status\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"new_old_member\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"\u65b0\u4f1a\u5458\"},{\"code\":\"2\",\"name\":\"\u8001\u4f1a\u5458\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u65b0\u4f1a\u5458\"],\"value\":\"\u65b0\u4f1a\u5458\",\"enumValue\":\"1\",\"enumOption\":\"new_old_member\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_lifecycle\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"\u6d3b\u8dc3\u4f1a\u5458\"},{\"code\":\"2\",\"name\":\"\u6c89\u9ed8\u4f1a\u5458\"},{\"code\":\"3\",\"name\":\"\u6fd2\u4e34\u7761\u7720\u4f1a\u5458\"},{\"code\":\"4\",\"name\":\"\u4f11\u7720\u4f1a\u5458\"},{\"code\":\"5\",\"name\":\"\u6d41\u5931\u4f1a\u5458\"},{\"code\":\"6\",\"name\":\"\u672a\u6d88\u8d39\u4f1a\u5458\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u6d3b\u8dc3\u4f1a\u5458\"],\"value\":\"\u6d3b\u8dc3\u4f1a\u5458\",\"enumValue\":\"1\",\"enumOption\":\"member_lifecycle\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"channel_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"10\",\"name\":\"\u5fae\u4fe1\"},{\"code\":\"20\",\"name\":\"\u7ebf\u4e0b\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u5fae\u4fe1\"],\"value\":\"\u5fae\u4fe1\",\"enumValue\":\"10\",\"enumOption\":\"channel\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"source_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"10\",\"name\":\"\u7231\u4e0a\u542f\u822a\u5c0f\u7a0b\u5e8f\"},{\"code\":\"20\",\"name\":\"\u4e0a\u6d77\u673a\u573a\u5c0f\u7a0b\u5e8f\"},{\"code\":\"30\",\"name\":\"\u6d66\u4e1c\u673a\u573a\u5c0f\u7a0b\u5e8f\"},{\"code\":\"40\",\"name\":\"\u7f24\u7eb7\u54c1\u8d2d\u5c0f\u7a0b\u5e8f\"},{\"code\":\"50\",\"name\":\"\u4e0a\u6d77\u673a\u573a\u8d35\u5bbe\u7ebf\u4e0aVIP\u5c0f\u7a0b\u5e8f\"},{\"code\":\"60\",\"name\":\"\u8679\u6865\u673a\u573a\u4ea4\u901a\u5c0f\u7a0b\u5e8f\"},{\"code\":\"70\",\"name\":\"\u6d66\u4e1c\u673a\u573a\u5546\u4e1aPOS\"},{\"code\":\"80\",\"name\":\"\u8679\u6865\u673a\u573a\u5546\u4e1aPOS\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u4e0a\u6d77\u673a\u573a\u5c0f\u7a0b\u5e8f\"],\"value\":\"\u4e0a\u6d77\u673a\u573a\u5c0f\u7a0b\u5e8f\",\"enumValue\":\"20\",\"enumOption\":\"mbr_source\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_basic_airport\",\"alias\":\"airport\",\"fieldName\":\"airport_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"\u6d66\u4e1c\u673a\u573a\"],\"value\":\"\u6d66\u4e1c\u673a\u573a\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_basic_building\",\"alias\":\"building\",\"fieldName\":\"building_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"T2\"],\"value\":\"T2\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_first_purchase_time\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"2024-11-01 00:00:00\",\"2024-12-31 23:59:59\"],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_first_purchase_store_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"HAHA\"],\"value\":\"HAHA\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_total_flight_times\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"MT\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{},\"selectValues\":[],\"value\":2,\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]}]}";
        TemplateUtil.makeupSql(Objects.requireNonNull(JacksonUtil.json2Obj(s, GroupConditionVo.class)));
    }

    public static String getBirthdaySql(SqlGetBirthdaySqlParam param) {
        String birthdayMDStart = param.getBirthdayMDStart();
        String birthdayMDEnd = param.getBirthdayMDEnd();
        String openCardTimeStart = param.getOpenCardTimeStart();
        String openCardTimeEnd = param.getOpenCardTimeEnd();
        List<String> mbrLevelDefCodeList = param.getMbrLevelDefCodeList();
        StringBuilder builder = new StringBuilder();
        builder.append(BIRTHDAY_SQL);
        builder.append(" from t_mbr_members m left join t_mkt_activity_send_record r on m.mbr_members_code = r.mbr_members_code and r.activity_type = 7 ");
        builder.append("and r.create_date >= '").append(DateUtils.formatLocalDateTime(DateUtils.getStartOfYear())).append("'");
        builder.append(" where r.mbr_members_code is null ");
        builder.append(" and m.birthday_md >= '").append(birthdayMDStart).append("'");
        builder.append(" and m.birthday_md <= '").append(birthdayMDEnd).append("'");
        if (StringUtils.isNotBlank((CharSequence)openCardTimeStart)) {
            builder.append(" and m.open_card_time >= '").append(openCardTimeStart).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)openCardTimeEnd)) {
            builder.append(" and m.open_card_time <= '").append(openCardTimeEnd).append("'");
        }
        if (CollectionUtils.isNotEmpty(mbrLevelDefCodeList)) {
            builder.append(" and m.mbr_level_def_code in ('").append(StringUtils.join(mbrLevelDefCodeList, (String)"','")).append("')");
        }
        return builder.toString();
    }

    public static String makeupSql(GroupConditionVo conditon) {
        TemplateUtil.validConditions(conditon);
        String sql = TemplateUtil.deal(conditon);
        if (!SqlCheckUtil.sqlInjection(sql)) {
            throw new RuntimeException("\u5b58\u5728SQL\u6ce8\u5165");
        }
        log.info("group sql:{}", (Object)sql);
        return sql;
    }

    private static String deal(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        builder.append(TemplateUtil.makeupSelect());
        builder.append(" from ");
        builder.append(TemplateUtil.makeupFrom(conditon));
        builder.append(" where ");
        if (StringUtils.isNotBlank((CharSequence)conditon.getMbrMembersCode())) {
            builder.append(" m.mbr_members_code = '").append(conditon.getMbrMembersCode()).append("' and ");
        }
        builder.append(TemplateUtil.makeupCondition(conditon));
        String orderBy = TemplateUtil.makeupOrderBy();
        builder.append(orderBy);
        return builder.toString();
    }

    private static String makeupFrom(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        ArrayList<GroupConditionValueVo> tableList = new ArrayList<GroupConditionValueVo>(conditon.getConditions().stream().flatMap(scv -> scv.getSubs().stream().filter(v -> !v.getTableName().equals("t_mbr_members"))).collect(Collectors.toMap(GroupConditionValueVo::getTableName, v -> v, (existing, replacement) -> existing)).values());
        conditon.getConditions().forEach(scv -> scv.getSubs().forEach(v -> v.setFieldName(v.getAlias() + "." + v.getFieldName())));
        builder.append(" t_mbr_members m ");
        for (GroupConditionValueVo valueVo : tableList) {
            if ("t_basic_airport".equals(valueVo.getTableName())) {
                builder.append(" join t_basic_airport airport on airport.airport_code=m.airport_code ");
                continue;
            }
            if ("t_basic_building".equals(valueVo.getTableName())) {
                builder.append(" join t_basic_building building on building.building_code=m.airport_detail_code ");
                continue;
            }
            if ("t_mbr_member_label".equals(valueVo.getTableName())) {
                builder.append(" join t_mbr_member_label label on label.mbr_members_code=m.mbr_members_code  join t_mbr_label_def labeld on label.mbr_label_def_code = labeld.mbr_label_def_code ");
                continue;
            }
            if ("t_mbr_level_def".equals(valueVo.getTableName())) {
                builder.append(" join t_mbr_level_def leveld on leveld.mbr_level_def_code=m.mbr_level_def_code ");
                continue;
            }
            builder.append(" join ");
            builder.append(valueVo.getTableName()).append(" ").append(valueVo.getAlias());
            builder.append(" on ").append(valueVo.getAlias()).append(".mbr_members_code=m.mbr_members_code");
        }
        return builder.toString();
    }

    private static String makeupSelect() {
        return " DISTINCT m.id AS id, m.mbr_members_code AS mbrMembersCode, m.card_no AS cardNo, m.name AS name, m.gender AS gender, m.phone AS phone, m.phone_encrypt AS phoneEncrypt, m.email AS email, m.id_card AS idCard, m.birthday AS birthday, m.province AS province, m.city AS city, m.county AS county, m.address AS address, m.head_portraits AS headPortraits, m.bar_code AS barCode, m.card_status AS cardStatus, m.status_flag AS statusFlag, m.open_card_time AS openCardTime, m.mbr_level_def_code AS mbrLevelDefCode, m.count_integral AS countIntegral, m.remark AS remark, m.create_user_code AS createUserCode, m.create_user_name AS createUserName, m.create_date AS createDate, m.modified_user_code AS modifiedUserCode, m.modified_user_name AS modifiedUserName, m.modified_date AS modifiedDate ";
    }

    private static String makeupCondition(GroupConditionVo conditon) {
        ArrayList<String> subs = new ArrayList<String>();
        for (GroupConditionSubVo scv : conditon.getConditions()) {
            int cnt = scv.getSubs().size();
            ArrayList<String> conditions = new ArrayList<String>();
            for (int i = 0; i < cnt; ++i) {
                conditions.add(TemplateUtil.getCondition(scv.getSubs().get(i)));
            }
            if (scv.getIsAnd() == 1) {
                subs.add(String.format("(%s)", String.join((CharSequence)" and ", conditions)));
                continue;
            }
            if (scv.getIsAnd() != 2) continue;
            subs.add(String.format("(%s)", String.join((CharSequence)" or ", conditions)));
        }
        if (conditon.getIsAnd() == 1) {
            return String.join((CharSequence)" and ", subs);
        }
        if (conditon.getIsAnd() == 2) {
            return String.join((CharSequence)" or ", subs);
        }
        return "1=1";
    }

    private static String getCondition(GroupConditionValueVo valueVo) {
        if (valueVo.getFieldDataType().equalsIgnoreCase("DATETIME")) {
            return TemplateUtil.getDateCondition(valueVo);
        }
        if (valueVo.getFieldDataType().equalsIgnoreCase("STRING")) {
            return TemplateUtil.getStringCondition(valueVo);
        }
        if (valueVo.getFieldDataType().equalsIgnoreCase("DECIMAL")) {
            return TemplateUtil.getDecimalCondition(valueVo);
        }
        if (valueVo.getFieldDataType().equalsIgnoreCase("ARRAY")) {
            return TemplateUtil.getArrayCondition(valueVo);
        }
        return "";
    }

    private static String makeupOrderBy() {
        return " Order by m.id asc";
    }

    private static String getArrayCondition(GroupConditionValueVo valueVo) {
        if (StringUtils.isNotEmpty((CharSequence)valueVo.getValue())) {
            String[] vals = valueVo.getValue().split(",");
            ArrayList<String> ors = new ArrayList<String>();
            for (String val : vals) {
                ors.add(String.format("instr(array_join(%s, '$'),'%s')>0 ", valueVo.getFieldName(), val));
            }
            return "(" + String.join((CharSequence)" or ", ors) + ")";
        }
        return "1=1";
    }

    private static String getFieldCondition(GroupConditionValueVo valueVo) {
        String[] vals;
        ArrayList<String> cons = new ArrayList<String>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        for (String val : vals = value.split(",")) {
            cons.add(fieldName + operator + val);
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join((CharSequence)" and ", cons));
        }
        return String.format("( %s )", String.join((CharSequence)" or ", cons));
    }

    private static String getStringCondition(GroupConditionValueVo valueVo) {
        ArrayList<String> cons = new ArrayList<String>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        if (StringUtils.isNotEmpty((CharSequence)valueVo.getEnumValue())) {
            value = valueVo.getEnumValue();
        }
        String[] vals = value.split(",");
        ArrayList<String> results = new ArrayList<String>();
        for (String val : vals) {
            cons.add(fieldName + operator + String.format("'%s'", val));
            if (valueVo.getFieldDataType().equals("DECIMAL")) {
                results.add(String.format("%s", val));
                continue;
            }
            results.add(String.format("'%s'", val));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s in (%s)", fieldName, String.join((CharSequence)",", results));
        }
        if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.EQUAL.getCode())) {
                return String.format("%s in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("%s not in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            return String.format("( %s )", String.join((CharSequence)" or ", cons));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join((CharSequence)" and ", cons));
        }
        return String.format("( %s )", String.join((CharSequence)" or ", cons));
    }

    private static String getDecimalCondition(GroupConditionValueVo valueVo) {
        ArrayList<String> cons = new ArrayList<String>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        ArrayList<String> results = new ArrayList<String>();
        for (String val : vals) {
            cons.add(fieldName + operator + val);
            results.add(String.format("%s", val));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s>=%s and %s<=%s", fieldName, valueVo.getIn().getVal1(), fieldName, valueVo.getIn().getVal1());
        }
        if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.EQUAL.getCode())) {
                return String.format("%s in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("%s not in (%s)", fieldName, String.join((CharSequence)",", results));
            }
            return String.format("( %s )", String.join((CharSequence)" or ", cons));
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join((CharSequence)" and ", cons));
        }
        return String.format("( %s )", String.join((CharSequence)" or ", cons));
    }

    private static String getDateCondition(GroupConditionValueVo valueVo) {
        String fieldName = valueVo.getFieldName();
        GroupConditionDateVo dateMap = valueVo.getDateMap();
        if (OperatorEnum.BETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        }
        if (OperatorEnum.NOTBETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " not between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        }
        if (valueVo.getMatch().getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode())) {
            if ("before".equals(dateMap.getType())) {
                return fieldName + " < '" + TemplateUtil.getDateFormat(dateMap.getUnit(), dateMap.getValue()) + "'";
            }
            if ("after".equals(dateMap.getType())) {
                return fieldName + " > '" + TemplateUtil.getDateFormat(dateMap.getUnit(), -dateMap.getValue().intValue()) + "'";
            }
        }
        return "1=1";
    }

    private static String getDateFormat(String unit, Integer value) {
        if ("day".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastDays(LocalDateTime.now(), value));
        }
        if ("hour".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastHours(LocalDateTime.now(), value));
        }
        if ("minute".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastMinutes(LocalDateTime.now(), value));
        }
        throw new RuntimeException("\u65f6\u95f4\u5355\u4f4d\u9519\u8bef");
    }

    private static void validConditions(GroupConditionVo condition) {
        if (condition != null && !CollectionUtils.isEmpty(condition.getConditions())) {
            TemplateUtil.validArgNegative(condition.getIsAnd(), "isAnd\u5c5e\u6027");
            for (GroupConditionSubVo sub : condition.getConditions()) {
                TemplateUtil.validArgNegative(sub.getIsAnd(), "isAnd\u5c5e\u6027");
                if (!CollectionUtils.isEmpty(sub.getSubs())) {
                    for (GroupConditionValueVo vv : sub.getSubs()) {
                        TemplateUtil.validArgNull(vv.getFieldName(), "\u5b57\u6bb5\u540d\u79f0");
                        TemplateUtil.validArgNull(vv.getFieldDataType(), "\u5b57\u6bb5\u7c7b\u578b");
                        if (vv.getMatch() == null) {
                            throw new RuntimeException("\u6761\u4ef6\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        TemplateUtil.validMatch(vv.getMatch());
                        if (vv.getFieldDataType().toUpperCase().equals("DECIMAL")) {
                            if (!StringUtils.isNotEmpty((CharSequence)vv.getValue())) continue;
                            String[] vals = vv.getValue().split(",");
                            TemplateUtil.validDecimal(vals, StringUtils.isNotEmpty((CharSequence)vv.getChnName()) ? vv.getChnName() : vv.getFieldName());
                            continue;
                        }
                        if (vv.getFieldDataType().toUpperCase().equals("STRING")) {
                            if (!StringUtils.isNotEmpty((CharSequence)vv.getValue()) || SqlCheckUtil.formFieldDataSqlInjection(vv.getValue())) continue;
                            throw new RuntimeException("\u4f20\u5165\u6761\u4ef6\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669");
                        }
                        if (!vv.getFieldDataType().toUpperCase().equals("DATETIME")) continue;
                        TemplateUtil.validDate(vv.getMatch(), vv.getDateMap(), vv.getDatetime());
                    }
                    continue;
                }
                throw new RuntimeException("\u5b50\u7ec4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private static void ValidInjection(String[] vals) {
        boolean existStart = false;
        boolean existEnd = false;
        for (String val : vals) {
            int cnt = TemplateUtil.countString(val.trim(), "'");
            if (cnt == 1) {
                existStart = true;
            }
            if (cnt == 1 || cnt % 2 == 0) continue;
            existEnd = true;
        }
        if (existStart && existEnd) {
            throw new RuntimeException("\u4f20\u5165\u6761\u4ef6\u5b58\u5728SQL\u6ce8\u5165");
        }
    }

    private static int countString(String str, String s) {
        int count = 0;
        int len = str.length();
        while (str.indexOf(s) != -1) {
            str = str.substring(str.indexOf(s) + 1, str.length());
            ++count;
        }
        return count;
    }

    private static void validDecimal(String[] vals, String fieldName) {
        for (String val : vals) {
            if (StringUtils.isNotEmpty((CharSequence)val)) {
                try {
                    new BigDecimal(val);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6761\u4ef6\u5b57\u6bb5:" + fieldName + "\u662f\u6570\u503c\u578b\u5b57\u6bb5,\u4e0d\u80fd\u8f93\u5165\u975e\u6570\u503c\u578b\u7684\u503c");
                }
            }
            throw new RuntimeException("\u6761\u4ef6\u5b57\u6bb5:" + fieldName + "\u672a\u8d4b\u503c");
        }
    }

    private static void validDate(TableDictVO.MatchVo match, GroupConditionDateVo vo, List<String> datetime) {
        if (match.getOperator().equals(OperatorEnum.BETWEEN.getCode()) && CollectionUtils.isEmpty(datetime)) {
            throw new RuntimeException("\u65f6\u95f4(select\u5c5e\u6027)\u672a\u8bbe\u7f6e");
        }
        if (match.getOperator().equals(OperatorEnum.NOTBETWEEN.getCode())) {
            if (CollectionUtils.isEmpty(datetime)) {
                throw new RuntimeException("\u65f6\u95f4(select\u5c5e\u6027)\u672a\u8bbe\u7f6e");
            }
        } else if (match.getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode()) && (StringUtils.isBlank((CharSequence)vo.getType()) || StringUtils.isBlank((CharSequence)vo.getUnit()) || vo.getValue() == null)) {
            throw new RuntimeException("\u65f6\u95f4(select\u5c5e\u6027)2\u672a\u8bbe\u7f6e");
        }
    }

    private static void validMatch(TableDictVO.MatchVo match) {
        TemplateUtil.validArgNull(match.getOperator(), "\u6bd4\u8f83\u65b9\u5f0f\u4ee3\u7801");
        if (!SqlOperatorUtil.contains(match.getOperator())) {
            throw new RuntimeException("\u6bd4\u8f83\u65b9\u5f0f\u4ee3\u7801" + match.getOperator() + "\u8bbe\u7f6e\u9519\u8bef");
        }
    }

    private static void validArgNull(String value, String msg) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new RuntimeException(msg + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void validArgNegative(Integer value, String msg) {
        if (value == null || value < 1) {
            throw new RuntimeException(msg + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

