package com.bizvane.utils.commonutils;


import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 日期处理工具类
 *
 * @author 董争光 2018年5月21日下午1:47:48
 */
public class DateUtils implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -4016651052102523560L;

    private static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    private static final String FORMAT_YYYYMMDD_HHMMSS = "yyyy-MM-dd HH:mm:ss";

    private static final String FORMAT_YYYYMMDD = "yyyyMMdd";

    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);

    private DateUtils() {

    }

    public static void main(String[] args) {
        System.out.println("Start of Day: " + getXdayAfterEnd(3));
    }

    public static LocalDateTime getXdayAfterEnd(int x) {
        LocalDateTime time = LocalDateTime.now().plusDays(x).toLocalDate().atTime(LocalTime.MAX);
        // 定义所需的格式
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD_HHMMSS);
        String formattedDateTimeString = time.format(formatter);

        return LocalDateTime.parse(formattedDateTimeString, formatter);
    }

    // 获取当前时间过去 X 天
    public static LocalDateTime getPastDays(LocalDateTime dateTime, int days) {
        return dateTime.minusDays(days);
    }

    // 获取当前时间过去 X 小时
    public static LocalDateTime getPastHours(LocalDateTime dateTime, int hours) {
        return dateTime.minusHours(hours);
    }

    // 获取当前时间过去 X 分钟
    public static LocalDateTime getPastMinutes(LocalDateTime dateTime, int minutes) {
        return dateTime.minusMinutes(minutes);
    }

    // 格式化时间为字符串，方便输出
    public static String formatDateTime(LocalDateTime dateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return dateTime.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        // 定义所需的格式
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        // 将 LocalDateTime 转换为字符串
        return localDateTime.format(formatter);
    }

    public static String formatYyyymmddhhmmss(LocalDateTime localDateTime) {
        // 定义所需的格式
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDDHHMMSS);

        // 将 LocalDateTime 转换为字符串
        return localDateTime.format(formatter);
    }

    public static String formatYyyymmdd(LocalDateTime localDateTime) {
        // 定义所需的格式
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD);

        // 将 LocalDateTime 转换为字符串
        return localDateTime.format(formatter);
    }


    public static LocalDateTime getStartOfDay() {
        return LocalDateTime.now().with(LocalTime.MIN);
    }

    // 返回当周开始时间
    public static LocalDateTime getStartOfWeek() {
        return LocalDateTime.now()
                .with(DayOfWeek.MONDAY)
                .with(LocalTime.MIN);
    }

    // 返回当月开始时间
    public static LocalDateTime getStartOfMonth() {
        return LocalDateTime.now()
                .withDayOfMonth(1)
                .with(LocalTime.MIN);
    }

    // 返回当年开始时间
    public static LocalDateTime getStartOfYear() {
        return LocalDateTime.now()
                .withDayOfYear(1)
                .with(LocalTime.MIN);
    }

    public static Date longFormatDate(Long time) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String d = format.format(time);
            return format.parse(d);
        } catch (Exception e) {
            DateUtils.logger.info("", e);
            return null;
        }
    }

    public static String dateFormatTime(Date currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String dateFormatDate(Date currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getStringNoDate(Date currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static Date getTimeByMinute(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MINUTE, minute);
        return calendar.getTime();
    }

    /**
     * 字符串的日期格式的计算
     *
     * @throws java.text.ParseException
     */
    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / (1000 * 3600 * 24);

        return Integer.parseInt(String.valueOf(between_days));
    }

    /**
     * 字符串的日期格式的计算
     *
     * @throws java.text.ParseException
     */
    public static String getNowYearMothDay() {
        String dString = "";
        try {
            Calendar now = Calendar.getInstance();
            dString = String.valueOf(now.get(Calendar.YEAR)) + String.valueOf((now.get(Calendar.MONTH) + 1))
                    + String.valueOf(now.get(Calendar.DAY_OF_MONTH)) + String.valueOf(now.get(Calendar.HOUR_OF_DAY))
                    + String.valueOf(now.get(Calendar.MINUTE)) + String.valueOf(now.get(Calendar.SECOND));
        } catch (Exception e) {
            e.printStackTrace();
        }

        return dString;
    }

    public static String formatStringByPattern(String date) {
        DateUtils.logger.info("date:" + date);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTimeStr = "";
        try {
            dateTimeStr = format1.format(format.parse(date));
        } catch (Exception e) {
            e.printStackTrace();
        }


        DateUtils.logger.info("result:" + dateTimeStr);
        return dateTimeStr;
    }

    public static String DateFormatString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String newDate = sdf.format(date);
        return newDate;
    }

    public static Date StringFormatDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return date;
    }

    public static Date stringFormatTime(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return date;
    }

    public static long StringFormartLong(String dateStr) {
        java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(dateStr);

            return date.getTime();
        } catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * 获取YYYY-MM-DD hh:mm:ss类型的当前时间
     */
    public static String getNowDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
        return df.format(new Date());
    }

    /**
     * 计算两个日期之间的天数
     *
     * @param fDate
     * @param oDate
     * @return
     */
    public static int daysOfTwoCount(Date fDate, Date lDate) {

        Calendar aCalendar = Calendar.getInstance();

        aCalendar.setTime(fDate);

        int day1 = aCalendar.get(Calendar.DAY_OF_YEAR);

        aCalendar.setTime(lDate);

        int day2 = aCalendar.get(Calendar.DAY_OF_YEAR);

        return day2 - day1;

    }

    public static Date getTodayStartTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date startTime = null;
        try {
            startTime = sdf.parse(sDate + " 00:00:00");
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return startTime;
    }

    public static Date getTodayEndTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date endTime = null;
        try {
            endTime = sdf.parse(sDate + " 23:59:59");
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return endTime;
    }


    public static Date getThisMonthStartTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date startTime = null;
        try {
            startTime = sdf.parse(sDate + " 00:00:00");
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return startTime;
    }

    public static Date getThisMonthEndTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date endTime = null;
        try {
            endTime = sdf.parse(sDate + " 23:59:59");
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return endTime;
    }


    @Deprecated
    public static Date getSpecifiedDayBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        c.setTime(formatDate);
        int day = c.get(Calendar.DATE);
        c.set(Calendar.DATE, day - before);

        return c.getTime();
    }

    @Deprecated
    public static Date getSpecifiedHourBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        c.setTime(formatDate);
        int day = c.get(Calendar.HOUR);
        c.set(Calendar.DATE, day - before);

        return c.getTime();
    }

    @Deprecated
    public static Date getSpecifiedMinuteBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        c.setTime(formatDate);
        int day = c.get(Calendar.MINUTE);
        c.set(Calendar.DATE, day - before);

        return c.getTime();
    }

    public static Date getFormateStringDate(String str) {
        Date date = null;
        try {
            date = org.apache.commons.lang3.time.DateUtils.parseDate(str, new String[] {"yyyy-MM-dd"});
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getSpecifiedDayBefore(String specifiedDay) {
        // SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd").parse(specifiedDay);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(Calendar.DATE);
        c.set(Calendar.DATE, day - 1);

        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    @Deprecated
    public static String formatYYYYMMDDHHmmSS(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }
}
