package com.bizvane.utils.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author smzdm
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class AsynCommonBo<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 只读. 企业id. sys_company_id
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "企业id",name = "sysCompanyId")
    private Long sysCompanyId;

    /**
     * 只读. 品牌id. sys_brand_id
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "品牌id",name = "sysBrandId")
    private Long sysBrandId;

    /**
     * 只读. 第三方渠道appid. third_appid
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "第三方渠道appid",name = "thirdAppid")
    private String thirdAppid;

    /**
     * 只读. 第三方类型(枚举). third_type
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "第三方类型(枚举)",name = "thirdType")
    private String thirdType;

    /**
     * 只读. 第三方类型名称. third_type_name
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "第三方类型名称",name = "thirdTypeName")
    private String thirdTypeName;

    /**
     * 只读. 业务类型(枚举). business_type
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "业务类型(枚举)",name = "businessType")
    private String businessType;

    /**
     * 只读. 业务类型名称. business_type_name
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "业务类型名称",name = "businessTypeName")
    private String businessTypeName;

    /**
     * 只读. 对象转换标识. bean_utils_code
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "对象转换标识",name = "beanUtilsCode")
    private String beanUtilsCode;

    /**
     * 只读. 商帆系统版本. sf_system_version
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "商帆系统版本",name = "sfSystemVersion")
    private String sfSystemVersion;

    /**
     * 只读. 三方系统版本. third_system_version
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "三方系统版本",name = "thirdSystemVersion")
    private String thirdSystemVersion;

    /**
     * 只读. 业务数据对象. data
     *
     * @mbg.generated
     */
    @ApiModelProperty(value = "业务数据对象",name = "businessData")
    private T businessData;



}
