package com.bizvane.utils.sql;

import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.commonutils.SqlCheckUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
@Slf4j
public class TemplateUtil {

    private static final String BIRTHDAY_SQL = "select m.id, m.mbr_members_code, m.card_no, m.name, m.gender, m.phone, m.phone_encrypt, m.email, m.id_card, m.birthday, m.province, m.city, m.county, m.address, m.head_portraits, m.bar_code, m.card_status, m.status_flag, m.open_card_time, mbr_level_def_code, m.extend_ids, m.count_integral, m.remark, m.create_user_code, m.create_user_name, m.create_date, m.modified_user_code, m.modified_user_name, m.modified_date ";

    public static void main(String[] args) {
        String s = "{\"isAnd\":1,\"conditions\":[{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"邸淑英\"],\"value\":\"邸淑英\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"card_no\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"SIA20241125000001\"],\"value\":\"SIA20241125000001\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"phone_encrypt\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"17521176876\"],\"value\":\"17521176876\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"gender\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"女\"},{\"code\":\"2\",\"name\":\"男\"},{\"code\":\"3\",\"name\":\"未知\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"男\"],\"value\":\"男\",\"enumValue\":\"2\",\"enumOption\":\"gender\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_age\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"IN\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":18,\"val2\":36},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"birthday_md\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"0301\",\"0331\"],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_level_def\",\"alias\":\"m\",\"fieldName\":\"level_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"银卡会员\"],\"value\":\"银卡会员\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"mbr_level_def_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"A0002\"],\"value\":\"A0002\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"province\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"山西省\"],\"value\":\"山西省\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"city\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"太原市\"],\"value\":\"太原市\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"county\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"榆木县\"],\"value\":\"榆木县\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":true}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_member_label\",\"alias\":\"labeld\",\"fieldName\":\"label_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"哈哈\"],\"value\":\"哈哈\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"count_integral\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"MT\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{},\"selectValues\":[],\"value\":100,\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"open_card_time\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"2024-10-01 00:00:00\",\"2024-12-31 23:59:59\"],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"card_status\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"正常\"},{\"code\":\"0\",\"name\":\"冻结\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"正常\"],\"value\":\"正常\",\"enumValue\":\"1\",\"enumOption\":\"card_status\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"new_old_member\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"新会员\"},{\"code\":\"2\",\"name\":\"老会员\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"新会员\"],\"value\":\"新会员\",\"enumValue\":\"1\",\"enumOption\":\"new_old_member\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_lifecycle\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"1\",\"name\":\"活跃会员\"},{\"code\":\"2\",\"name\":\"沉默会员\"},{\"code\":\"3\",\"name\":\"濒临睡眠会员\"},{\"code\":\"4\",\"name\":\"休眠会员\"},{\"code\":\"5\",\"name\":\"流失会员\"},{\"code\":\"6\",\"name\":\"未消费会员\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"活跃会员\"],\"value\":\"活跃会员\",\"enumValue\":\"1\",\"enumOption\":\"member_lifecycle\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"channel_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"10\",\"name\":\"微信\"},{\"code\":\"20\",\"name\":\"线下\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"微信\"],\"value\":\"微信\",\"enumValue\":\"10\",\"enumOption\":\"channel\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_members\",\"alias\":\"m\",\"fieldName\":\"source_code\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[{\"code\":\"10\",\"name\":\"爱上启航小程序\"},{\"code\":\"20\",\"name\":\"上海机场小程序\"},{\"code\":\"30\",\"name\":\"浦东机场小程序\"},{\"code\":\"40\",\"name\":\"缤纷品购小程序\"},{\"code\":\"50\",\"name\":\"上海机场贵宾线上VIP小程序\"},{\"code\":\"60\",\"name\":\"虹桥机场交通小程序\"},{\"code\":\"70\",\"name\":\"浦东机场商业POS\"},{\"code\":\"80\",\"name\":\"虹桥机场商业POS\"}],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"上海机场小程序\"],\"value\":\"上海机场小程序\",\"enumValue\":\"20\",\"enumOption\":\"mbr_source\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_basic_airport\",\"alias\":\"airport\",\"fieldName\":\"airport_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"浦东机场\"],\"value\":\"浦东机场\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_basic_building\",\"alias\":\"building\",\"fieldName\":\"building_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"T2\"],\"value\":\"T2\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_first_purchase_time\",\"fieldDataType\":\"DATETIME\",\"match\":{\"operator\":\"BT\"},\"enums\":[],\"datetime\":[\"2024-11-01 00:00:00\",\"2024-12-31 23:59:59\"],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[],\"value\":\"\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_first_purchase_store_name\",\"fieldDataType\":\"STRING\",\"match\":{\"operator\":\"EQ\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{\"val1\":\"\",\"val2\":\"\"},\"selectValues\":[\"HAHA\"],\"value\":\"HAHA\",\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]},{\"isAnd\":1,\"subs\":[{\"tableName\":\"t_mbr_consume_behavior\",\"alias\":\"c\",\"fieldName\":\"member_total_flight_times\",\"fieldDataType\":\"DECIMAL\",\"match\":{\"operator\":\"MT\"},\"enums\":[],\"datetime\":[],\"dateMap\":{\"type\":\"before\",\"value\":0,\"unit\":\"day\"},\"in\":{},\"selectValues\":[],\"value\":2,\"enumValue\":\"\",\"enumOption\":\"\",\"isLike\":false}]}]}";
        makeupSql(Objects.requireNonNull(JacksonUtil.json2Obj(s, GroupConditionVo.class)));
    }

    public static String getBirthdaySql(SqlGetBirthdaySqlParam param) {
        String birthdayMDStart = param.getBirthdayMDStart();
        String birthdayMDEnd = param.getBirthdayMDEnd();
        String openCardTimeStart = param.getOpenCardTimeStart();
        String openCardTimeEnd = param.getOpenCardTimeEnd();
        List<String> mbrLevelDefCodeList = param.getMbrLevelDefCodeList();

        StringBuilder builder = new StringBuilder();
        builder.append(BIRTHDAY_SQL);
        builder.append(" from t_mbr_members m left join t_mkt_activity_send_record r on m.mbr_members_code = r.mbr_members_code and r.activity_type = 7 ");
        builder.append("and r.create_date >= '").append(DateUtils.formatLocalDateTime(DateUtils.getStartOfYear())).append("'");
        builder.append(" where r.mbr_members_code is null ");
        builder.append(" and m.birthday_md >= '").append(birthdayMDStart).append("'");
        builder.append(" and m.birthday_md <= '").append(birthdayMDEnd).append("'");
        if (StringUtils.isNotBlank(openCardTimeStart)) {
            builder.append(" and m.open_card_time >= '").append(openCardTimeStart).append("'");
        }
        if (StringUtils.isNotBlank(openCardTimeEnd)) {
            builder.append(" and m.open_card_time <= '").append(openCardTimeEnd).append("'");
        }
        if (CollectionUtils.isNotEmpty(mbrLevelDefCodeList)) {
            builder.append(" and m.mbr_level_def_code in ('").append(StringUtils.join(mbrLevelDefCodeList, "','")).append("')");
        }
        return builder.toString();

    }

    public static String makeupSql(GroupConditionVo conditon) {

        validConditions(conditon);

        String sql = deal(conditon);

        if (!SqlCheckUtil.sqlInjection(sql)) {
            throw new RuntimeException("存在SQL注入");
        }
        log.info("group sql:{}", sql);
        return sql;
    }

    private static String deal(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        builder.append(makeupSelect());
        builder.append(" from ");
        builder.append(makeupFrom(conditon));
        builder.append(" where ");
        if (StringUtils.isNotBlank(conditon.getMbrMembersCode())) {
            builder.append(" m.mbr_members_code = '").append(conditon.getMbrMembersCode()).append("' and ");
        }
        builder.append(makeupCondition(conditon));

        String orderBy = makeupOrderBy();
        builder.append(orderBy);

        return builder.toString();
    }

    /**
     * 组装查询表
     */
    private static String makeupFrom(GroupConditionVo conditon) {
        StringBuilder builder = new StringBuilder();
        List<GroupConditionValueVo> tableList = new ArrayList<>(conditon.getConditions().stream()
                .flatMap(scv -> scv.getSubs().stream()
                        .filter(v -> !v.getTableName().equals("t_mbr_members")) // 排除掉 t_mbr_members
                )
                .collect(Collectors.toMap(
                        GroupConditionValueVo::getTableName, // 使用 tableName 作为键
                        v -> v, // 值为 ValueVo 对象本身
                        (existing, replacement) -> existing // 如果遇到重复，保留第一个
                ))
                .values());

        conditon.getConditions().forEach(scv -> scv.getSubs().forEach(v->
                v.setFieldName(v.getAlias() + "." + v.getFieldName())
        ));

        builder.append(" t_mbr_members m ");
        for (GroupConditionValueVo valueVo : tableList) {
            if ("t_basic_airport".equals(valueVo.getTableName())) {
                builder.append(" join t_basic_airport airport on airport.airport_code=m.airport_code ");
            } else if ("t_basic_building".equals(valueVo.getTableName())) {
                builder.append(" join t_basic_building building on building.building_code=m.airport_detail_code ");
            } else if ("t_mbr_member_label".equals(valueVo.getTableName())) {
                //t_mbr_member_label label join t_mbr_label_def labeld on label.mbr_label_def_code on labeld.mbr_label_def_code
                builder.append(" join t_mbr_member_label label on label.mbr_members_code=m.mbr_members_code " +
                        " join t_mbr_label_def labeld on label.mbr_label_def_code = labeld.mbr_label_def_code ");
            } else if ("t_mbr_level_def".equals(valueVo.getTableName())) {
                builder.append(" join t_mbr_level_def leveld on leveld.mbr_level_def_code=m.mbr_level_def_code ");
            } else {
                builder.append(" join ");
                builder.append(valueVo.getTableName()).append(" ").append(valueVo.getAlias());
                builder.append(" on ").append(valueVo.getAlias()).append(".mbr_members_code=m.mbr_members_code");
            }
         }

        return builder.toString();
    }

    /**
     * 组装查询列
     */
    private static String makeupSelect() {
        return " distinct m.id, m.mbr_members_code, m.card_no, m.name, m.gender, m.phone, m.phone_encrypt, m.email, m.id_card, m.birthday, m.province, m.city, m.county, m.address, m.head_portraits, m.bar_code, m.card_status, m.status_flag, m.open_card_time, m.mbr_level_def_code, m.count_integral, m.remark, m.create_user_code, m.create_user_name, m.create_date, m.modified_user_code, m.modified_user_name, m.modified_date";
    }

    /**
     * 组装条件
     */
    private static String makeupCondition(GroupConditionVo conditon) {

        List<String> subs = new ArrayList<>();

        for (GroupConditionSubVo scv : conditon.getConditions()) {
            int cnt = scv.getSubs().size();
            List<String> conditions = new ArrayList<>();
            for (int i = 0; i < cnt; i++) {
                conditions.add(getCondition(scv.getSubs().get(i)));
            }
            if (scv.getIsAnd() == 1) {
                subs.add(String.format("(%s)", String.join(" and ", conditions)));
            } else if (scv.getIsAnd() == 2) {
                subs.add(String.format("(%s)", String.join(" or ", conditions)));
            }
        }

        if (conditon.getIsAnd() == 1) {
            return String.join(" and ", subs);
        } else if (conditon.getIsAnd() == 2) {
            return String.join(" or ", subs);
        }
        return "1=1";
    }

    private static String getCondition(GroupConditionValueVo valueVo) {
        if (valueVo.getFieldDataType().equalsIgnoreCase("DATETIME")) {
            return getDateCondition(valueVo);
        } if (valueVo.getFieldDataType().equalsIgnoreCase("STRING")) {
            return getStringCondition(valueVo);
        } else if (valueVo.getFieldDataType().equalsIgnoreCase("DECIMAL")) {
            return getDecimalCondition(valueVo);
        } else if (valueVo.getFieldDataType().equalsIgnoreCase("ARRAY")) {
            return getArrayCondition(valueVo);
        }

        return "";
    }

    private static String makeupOrderBy() {

        return " Order by m.id asc";
    }

    private static String getArrayCondition(GroupConditionValueVo valueVo) {
        if (StringUtils.isNotEmpty(valueVo.getValue())) {
            String[] vals = valueVo.getValue().split(",");
            // String val = StringUtils.join(vals, "','");

            List<String> ors = new ArrayList<>();
            for (String val : vals) {
                ors.add(String.format("instr(array_join(%s, '$'),'%s')>0 ", valueVo.getFieldName(), val));
            }

            return "(" + String.join(" or ", ors) + ")";
        }

        return "1=1";
    }

    private static String getFieldCondition(GroupConditionValueVo valueVo) {
        List<String> cons = new ArrayList<>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        for (String val : vals) {
            cons.add(fieldName + operator + val);
        }

        if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
            return String.format("( %s )", String.join(" and ", cons));
        } else {
            return String.format("( %s )", String.join(" or ", cons));
        }
    }

    private static String getStringCondition(GroupConditionValueVo valueVo) {
        List<String> cons = new ArrayList<>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        if (StringUtils.isNotEmpty(valueVo.getEnumValue())) {
            value = valueVo.getEnumValue();
        }
        String[] vals = value.split(",");
        List<String> results = new ArrayList<>();
        for (String val : vals) {
            cons.add(fieldName + operator + String.format("'%s'", val));
            if (valueVo.getFieldDataType().equals("DECIMAL")) {
                results.add(String.format("%s", val));
            } else {
                results.add(String.format("'%s'", val));
            }
        }

        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s in (%s)", fieldName, String.join(",", results));
        } else if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals((OperatorEnum.EQUAL.getCode()))) {
                return String.format("%s in (%s)", fieldName, String.join(",", results));
            } else if (valueVo.getMatch().getOperator().equals((OperatorEnum.NOTEQUAL.getCode()))) {
                return String.format("%s not in (%s)", fieldName, String.join(",", results));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        } else {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("( %s )", String.join(" and ", cons));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        }
    }

    private static String getDecimalCondition(GroupConditionValueVo valueVo) {
        List<String> cons = new ArrayList<>();
        String fieldName = valueVo.getFieldName();
        String operator = SqlOperatorUtil.getOperator(valueVo.getMatch().getOperator());
        String value = valueVo.getValue();
        String[] vals = value.split(",");
        List<String> results = new ArrayList<>();
        for (String val : vals) {
            cons.add(fieldName + operator + val);
            results.add(String.format("%s", val));
        }

        if (valueVo.getMatch().getOperator().equals(OperatorEnum.RANGE.getCode())) {
            return String.format("%s>=%s and %s<=%s", fieldName, valueVo.getIn().getVal1(), fieldName, valueVo.getIn().getVal1());
            /*if (results.size() == 2) {
                return String.format("%s>=%s and %s<=%s", fieldName, results.get(0), fieldName, results.get(1));
            } else {
                return String.format("%s in (%s)", fieldName, String.join(",", results));
            }*/
        } else if (results.size() > 200) {
            if (valueVo.getMatch().getOperator().equals((OperatorEnum.EQUAL.getCode()))) {
                return String.format("%s in (%s)", fieldName, String.join(",", results));
            } else if (valueVo.getMatch().getOperator().equals((OperatorEnum.NOTEQUAL.getCode()))) {
                return String.format("%s not in (%s)", fieldName, String.join(",", results));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        } else {
            if (valueVo.getMatch().getOperator().equals(OperatorEnum.NOTEQUAL.getCode())) {
                return String.format("( %s )", String.join(" and ", cons));
            } else {
                return String.format("( %s )", String.join(" or ", cons));
            }
        }
    }

    private static String getDateCondition(GroupConditionValueVo valueVo) {
        String fieldName = valueVo.getFieldName();
        GroupConditionDateVo dateMap = valueVo.getDateMap();

        if (OperatorEnum.BETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        } else if (OperatorEnum.NOTBETWEEN.getCode().equals(valueVo.getMatch().getOperator())) {
            return fieldName + " not between '" + valueVo.getDatetime().get(0) + "' and '" + valueVo.getDatetime().get(1) + "'";
        } else if (valueVo.getMatch().getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode())) {
            if ("before".equals(dateMap.getType())) {
                return fieldName + " < '" + getDateFormat(dateMap.getUnit(), dateMap.getValue()) + "'";
            } else if ("after".equals(dateMap.getType())) {
                return fieldName + " > '" + getDateFormat(dateMap.getUnit(), -dateMap.getValue()) + "'";
            }
        }
        return "1=1";
    }

    private static String getDateFormat(String unit, Integer value) {
        if ("day".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastDays(LocalDateTime.now(), value));
        } else if ("hour".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastHours(LocalDateTime.now(),value));
        } else if ("minute".equals(unit)) {
            return DateUtils.formatLocalDateTime(DateUtils.getPastMinutes(LocalDateTime.now(),value));
        } else {
            throw new RuntimeException("时间单位错误");
        }
    }

    private static void validConditions(GroupConditionVo condition) {
        if (condition != null && !CollectionUtils.isEmpty(condition.getConditions())) {

            validArgNegative(condition.getIsAnd(), "isAnd属性");

            for (GroupConditionSubVo sub : condition.getConditions()) {

                validArgNegative(sub.getIsAnd(), "isAnd属性");

                if (!CollectionUtils.isEmpty(sub.getSubs())) {
                    for (GroupConditionValueVo vv : sub.getSubs()) {
                        validArgNull(vv.getFieldName(), "字段名称");
                        validArgNull(vv.getFieldDataType(), "字段类型");
                        if (vv.getMatch() == null) {
                            throw new RuntimeException("条件操作不能为空");
                        }
                        validMatch(vv.getMatch());

                        if (vv.getFieldDataType().toUpperCase().equals("DECIMAL")) {
                            if (StringUtils.isNotEmpty((vv.getValue()))) {
                                String[] vals = vv.getValue().split(",");
                                validDecimal(vals, StringUtils.isNotEmpty(vv.getChnName()) ? vv.getChnName() : vv.getFieldName());
                            }
                        } else if (vv.getFieldDataType().toUpperCase().equals("STRING")) {
                            if (StringUtils.isNotEmpty((vv.getValue()))) {
                                if (!SqlCheckUtil.formFieldDataSqlInjection(vv.getValue())) {
                                    throw new RuntimeException("传入条件存在SQL注入风险");
                                }
                            }
                        } else if (vv.getFieldDataType().toUpperCase().equals("DATETIME")) {
                            validDate(vv.getMatch(), vv.getDateMap(), vv.getDatetime());
                        }

                    }
                } else {
                    throw new RuntimeException("子组条件不能为空");
                }
            }

        }
    }

    private static void ValidInjection(String[] vals) {
        boolean existStart = false;
        boolean existEnd = false;
        for (String val : vals) {
            int cnt = countString(val.trim(), "'");
            if (cnt == 1) {
                existStart = true;
            }
            if (cnt != 1) {
                if (cnt % 2 != 0) {
                    existEnd = true;
                }
            }
        }

        if (existStart && existEnd) {
            throw new RuntimeException("传入条件存在SQL注入");
        }
    }

    private static int countString(String str, String s) {
        int count = 0, len = str.length();
        while (str.indexOf(s) != -1) {
            str = str.substring(str.indexOf(s) + 1, str.length());
            count++;
        }
        return count;
    }

    private static void validDecimal(String[] vals, String fieldName) {
        for (String val : vals) {
            if (StringUtils.isNotEmpty(val)) {
                try {
                    new BigDecimal(val);
                } catch (Exception e) {
                    throw new RuntimeException("条件字段:" + fieldName + "是数值型字段,不能输入非数值型的值");
                }
            } else {
                throw new RuntimeException("条件字段:" + fieldName + "未赋值");
            }
        }
    }


    private static void validDate(TableDictVO.MatchVo match, GroupConditionDateVo vo, List<String> datetime) {
        if (match.getOperator().equals(OperatorEnum.BETWEEN.getCode())) {
            if (CollectionUtils.isEmpty(datetime)) {
                throw new RuntimeException("时间(select属性)未设置");
            }
        }
        if (match.getOperator().equals(OperatorEnum.NOTBETWEEN.getCode())) {
            if (CollectionUtils.isEmpty(datetime)) {
                throw new RuntimeException("时间(select属性)未设置");
            }
        } else if (match.getOperator().equals(OperatorEnum.BEFOREORAFTERNOW.getCode())) {
            if (StringUtils.isBlank(vo.getType()) || StringUtils.isBlank(vo.getUnit()) || vo.getValue() == null) {
                throw new RuntimeException("时间(select属性)2未设置");
            }
        }
    }


    private static void validMatch(TableDictVO.MatchVo match) {
        validArgNull(match.getOperator(), "比较方式代码");
        //  validArgNull(match.getName(), "比较方式名称");
        if (!SqlOperatorUtil.contains(match.getOperator())) {
            throw new RuntimeException("比较方式代码" + match.getOperator() + "设置错误");
        }
    }
    private static void validArgNull(String value, String msg) {
        if (StringUtils.isEmpty((value))) {
            throw new RuntimeException(msg + "不能为空");
        }
    }

    private static void validArgNegative(Integer value, String msg) {
        if (value == null || value.intValue() < 1) {
            throw new RuntimeException(msg + "不能为空");
        }
    }
}
