package com.bizvane.utils.code;

import com.alibaba.fastjson.JSONObject;
import com.spire.barcode.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;

/**
 * @author bizvane
 */
public class BarcodeUtils {

    private static Logger logger = LoggerFactory.getLogger(BarcodeUtils.class);

    //图片类型
    private static final String FORMAT_NAME = "png";

    public static String generateBarCode(String code) {

        logger.info("enter BarcodeUtil generateBarCode param:msg:{}", code);

        //创建BarcodeSettings实例
        BarcodeSettings settings = new BarcodeSettings();
        //设置条形码类型
        settings.setType(BarCodeType.CODE_128);
        //设置条形码数据
        settings.setData(code);
        settings.setShowText(false);
        //在底部显示数据
        settings.setShowTextOnBottom(false);
        //设置边框为不可见
        settings.hasBorder(false);
        //创建BarCodeGenerator实例
        BarCodeGenerator barCodeGenerator = new BarCodeGenerator(settings);
        //根据settings生成图像数据，保存至BufferedImage实例
        BufferedImage image = barCodeGenerator.generateImage();

        ByteArrayOutputStream os = null;
        String resultImage = null;
        try {

            os = new ByteArrayOutputStream();
            ImageIO.write(image, FORMAT_NAME, os);

            resultImage = new String("data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray()));

        }catch (Exception e){
            logger.info("enter BarcodeUtil generateBarCode Exception:e:{}", JSONObject.toJSONString(e));
        } finally {
          try {
            os.close();
          } catch (IOException e) {
            // TODO Auto-generated catch block
            logger.error("关闭流失败：", e);
          }
        }

        return resultImage;

    }

  public static String generateQRCode(String code) {

      logger.info("enter BarcodeUtil generateQRCode param:msg:{}", code);

      //创建BarcodeSettings实例
      BarcodeSettings settings = new BarcodeSettings();
      //设置条形码类型
      settings.setType(BarCodeType.QR_CODE);
      //设置条形码数据
      settings.setData(code);
      settings.setShowText(false);

      //设置数据类型
      settings.setQRCodeDataMode(QRCodeDataMode.ALPHA_NUMBER);
      //设置二维码模型宽度
      settings.setX(2.5f);
      settings.setY(2.5f);
      //设置二维码纠错级别
      settings.setQRCodeECL(QRCodeECL.H);

      settings.hasBorder(false);//设置二维码边框不可见
      settings.setData2D(null);
      settings.setShowTopText(false);
      settings.setShowText(false);
      settings.setBottomMargin(0);
      settings.setTopMargin(0);
      settings.setLeftMargin(0);
      settings.setRightMargin(0);

      //创建BarCodeGenerator实例
      BarCodeGenerator barCodeGenerator = new BarCodeGenerator(settings);
      //根据settings生成图像数据，保存至BufferedImage实例
      BufferedImage image = barCodeGenerator.generateImage();

      ByteArrayOutputStream os = null;
      String resultImage = null;
      try {
          os = new ByteArrayOutputStream();
          ImageIO.write(image, FORMAT_NAME, os);

          resultImage = new String("data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray()));
          
          os.close();

      }catch (Exception e){
          logger.info("enter BarcodeUtil generateQRCode Exception:e:{}", JSONObject.toJSONString(e));
      } finally {
        try {
          os.close();
        } catch (IOException e) {
          // TODO Auto-generated catch block
          logger.error("关闭流失败：", e);
        }
      }

      return resultImage;

  }

}
