/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.excel;

import com.bizvane.utils.exception.BizException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportUtil.class);

    public static void main(String[] args) {
        new ExcelImportUtil().parseExcel("https://airport-uat-1329502467.cos.ap-shanghai.myqcloud.com:443/doc/adafe03a12944ac18f49d2b0eead68b1.xlsx");
    }

    public List<List<String>> parseExcel(String filePath) {
        ArrayList<List<String>> data;
        block28: {
            log.info("ExcelImportUtil.parseExcel:{}", (Object)filePath);
            data = new ArrayList<List<String>>();
            try {
                URL url = new URL(filePath);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() == 200) {
                    try (InputStream inputStream = connection.getInputStream();
                         Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
                        Sheet sheet = workbook.getSheetAt(0);
                        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                            Row row = sheet.getRow(rowIndex);
                            if (rowIndex == 0) continue;
                            List<String> rowData = ExcelImportUtil.getStrings(row);
                            data.add(rowData);
                        }
                        break block28;
                    }
                }
                log.info("Failed to load file. HTTP response code: {}", (Object)connection.getResponseCode());
            }
            catch (Exception e) {
                log.error("ExcelImportUtil.error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                throw new BizException("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
            }
        }
        return data;
    }

    @NotNull
    private static List<String> getStrings(Row row) {
        ArrayList<String> rowData = new ArrayList<String>();
        block6: for (Cell cell : row) {
            switch (cell.getCellType()) {
                case STRING: {
                    rowData.add(cell.getStringCellValue());
                    continue block6;
                }
                case NUMERIC: {
                    rowData.add(NumberToTextConverter.toText((double)cell.getNumericCellValue()));
                    continue block6;
                }
                case BOOLEAN: {
                    rowData.add(String.valueOf(cell.getBooleanCellValue()));
                    continue block6;
                }
                case FORMULA: {
                    rowData.add(cell.getCellFormula());
                    continue block6;
                }
            }
            rowData.add("");
        }
        return rowData;
    }
}

